package com.finalProject;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class MCC implements Controller, Runnable {
	
	private boolean active = true;
	private boolean[] keys = new boolean[10];
	private RawGraph map;
	
	public MCC() {
		Thread t = new Thread(this);
		t.start();
	}
	
	public void keyPressed(KeyEvent e) {
		int keyCode = e.getKeyCode();
		if(keyCode==KeyEvent.VK_W) {
			keys[0] = true;
		}else if(keyCode==KeyEvent.VK_S) {
			keys[1] = true;
		}
		
		if(keyCode==KeyEvent.VK_A) {
			keys[2]=true;
		}else if(keyCode==KeyEvent.VK_D) {
			keys[3]=true;
		}
		
		if(keyCode==KeyEvent.VK_SPACE) {
			keys[4]=true;
		}else if(keyCode==KeyEvent.VK_SHIFT) {
			keys[5]=true;
		}
		
		if(keyCode==KeyEvent.VK_LEFT) {
			keys[6]=true;
		}else if(keyCode==KeyEvent.VK_RIGHT) {
			keys[7]=true;
		}
		
		if(keyCode==KeyEvent.VK_UP) {
			keys[8]=true;
		}else if(keyCode==KeyEvent.VK_DOWN) {
			keys[9]=true;
		}
	}
	
	public void keyReleased(KeyEvent e) {
		int keyCode = e.getKeyCode();
		if(keyCode==KeyEvent.VK_W) {
			keys[0] = false;
		}else if(keyCode==KeyEvent.VK_S) {
			keys[1] = false;
		}
		
		if(keyCode==KeyEvent.VK_A) {
			keys[2]=false;
		}else if(keyCode==KeyEvent.VK_D) {
			keys[3]=false;
		}
		
		if(keyCode==KeyEvent.VK_SPACE) {
			keys[4]=false;
		}else if(keyCode==KeyEvent.VK_SHIFT) {
			keys[5]=false;
		}
		
		if(keyCode==KeyEvent.VK_LEFT) {
			keys[6]=false;
		}else if(keyCode==KeyEvent.VK_RIGHT) {
			keys[7]=false;
		}		
	
		if(keyCode==KeyEvent.VK_UP) {
			keys[8]=false;
		}else if(keyCode==KeyEvent.VK_DOWN) {
			keys[9]=false;
		}
	}
	
	public void keyTyped(KeyEvent e) {
		
	}
	
	public void run() {
		while(active) {
			move();
			try {
				Thread.sleep(10);
			}catch(Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public void move() {
		if(keys[0]) {
			if(!Transform.translateZ(map.getGraphs()[0], -9))System.out.println("Collide");
		}else if(keys[1]) {
			if(!Transform.translateZ(map.getGraphs()[0], 9))System.out.println("Collide");
		}
		
		
		if(keys[2]) {
			if(!Transform.translateX(map.getGraphs()[0], 1))System.out.println("Collide");
		}else if(keys[3]) {
			if(!Transform.translateX(map.getGraphs()[0], -1))System.out.println("Collide");
		}
		
		
		if(keys[4]) {
			if(!Transform.translateY(map.getGraphs()[0], 3))System.out.println("Collide");
		}else if(keys[5]) {
			if(!Transform.translateY(map.getGraphs()[0], -3))System.out.println("Collide");
		}
		
		
		if(keys[6]) {
			Transform.rotateZ(map.getGraphs()[0], 1);
		}else if(keys[7]) {
			Transform.rotateZ(map.getGraphs()[0], -1);
		}	
		
		if(keys[8]) {
			Transform.rotateX(map.getGraphs()[0], 1);
		}else if(keys[9]) {
			Transform.rotateX(map.getGraphs()[0], -1);
		}
		
		
	}
	
	
	public void setRawGraph(RawGraph raw) {
		map = raw;
	}
	
	public Force[] getForces() {
		return null;
	}

	@Override
	public void mouseClicked(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseEntered(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseExited(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mousePressed(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void mouseReleased(MouseEvent arg0) {
		// TODO Auto-generated method stub
		
	}
	int xL, yL;
	public void mouseDragged(MouseEvent e) {
		Transform.rotateY(map.getGraphs()[0], xL-e.getX());
		xL=e.getX();
		yL=e.getY();
	}
	public void mouseMoved(MouseEvent e) {
		xL=e.getX();
		yL=e.getY();
	}

	@Override
	public void setBMap(Graphics g3) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setAMap(Graphics g3) {
		// TODO Auto-generated method stub
		
	}

	

}
