package com.finalProject;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;


public class Plane {
	
	private int[] points;
	private Color color = Color.WHITE;
	private Color shade = new Color(0,0,0,0);
	
	public Plane(int[] p) {
		points=p;
	}
	
	public void drawPlane(Graphics g3, Point3D[] p) {
		int[] xList = new int[points.length], yList = new int[points.length];
		int dontdrawb = 0;
		int dontdrawa = 0;
		for(int i=0; i<points.length; i++) {
			if(p[points[i]].z<-Constant.FOCAL) dontdrawb++;
			if(p[points[i]].z>Constant.RENDERDISTANCE) dontdrawa++;
			xList[i]=p[points[i]].getPoint2D().x;
			yList[i]=p[points[i]].getPoint2D().y;
		}
		if(dontdrawb==points.length || dontdrawa==points.length)return;
		Polygon poly = new Polygon(xList, yList, points.length);
		g3.setColor(new Color(color.getRed(),color.getGreen(),color.getBlue(), getShade(p)));
		g3.fillPolygon(poly);
	}
	
	public void setColor(Color c) {
		color = c;
	}
	
	public int getShade(Point3D[] p) {
		double low = p[0].z;
		for(int i=1; i<points.length; i++) {
			if(p[i].z<low) {
				low = p[i].z;
			}
		}
		if(low<0) {
			low=0;
		}
		int alpha = (int)((low/Constant.RENDERDISTANCE)*255);
		if(alpha>255)alpha=255;
		alpha = 255-alpha;
		return alpha;
	}
	
	
	public double onPlane(Point3D p, Point3D[] pointList) {
		Vector a = new Vector(pointList[points[0]],pointList[points[1]]);
		Vector b = new Vector(pointList[points[0]],pointList[points[2]]);
		double matrixX = (a.getSlope().y*b.getSlope().z)-(b.getSlope().y*a.getSlope().z);
		double matrixY = -((a.getSlope().x*b.getSlope().z)-(a.getSlope().z*b.getSlope().x));
		double matrixZ = (a.getSlope().x*b.getSlope().y)-(a.getSlope().y*b.getSlope().x);
		double DCompare = (matrixX*(pointList[points[0]].x))+(matrixY*(pointList[points[0]].y))+(matrixZ*(pointList[points[0]].z));
		double Dn = (matrixX*(p.x-(p.x%1)))+(matrixY*(p.y-(p.y%1)))+(matrixZ*(p.z-(p.z%1)));
		return (Dn-DCompare);
	}
	
	
	
	public boolean inPlaneXY(Point3D p, Point3D[] pointList) {
		int nvert = points.length;
		  int i, j;
		  boolean c = false;
		  for (i = 0, j = nvert-1; i < nvert; j = i++) {
		    if ( ((pointList[points[i]].y>=p.y) != (pointList[points[j]].y>=p.y)) && 
		    		(p.x <= (pointList[points[j]].x-pointList[points[i]].x) * (p.y-pointList[points[i]].y) / (pointList[points[j]].y-pointList[points[i]].y) + pointList[points[i]].x) )
		       c = !c;
		  }
		  return c;
	}
	public boolean inPlaneYZ(Point3D p, Point3D[] pointList) {
		int nvert = points.length;
		  int i, j;
		  boolean c = false;
		  for (i = 0, j = nvert-1; i < nvert; j = i++) {
		    if ( ((pointList[points[i]].y>=p.y) != (pointList[points[j]].y>=p.y)) && 
		    		(p.z <= (pointList[points[j]].z-pointList[points[i]].z) * (p.y-pointList[points[i]].y) / (pointList[points[j]].y-pointList[points[i]].y) + pointList[points[i]].z) )
		       c = !c;
		  }
		  return c;
	}
	public boolean inPlaneXZ(Point3D p, Point3D[] pointList) {
		int nvert = points.length;
		  int i, j;
		  boolean c = false;
		  for (i = 0, j = nvert-1; i < nvert; j = i++) {
		    if ( ((pointList[points[i]].z>=p.z) != (pointList[points[j]].z>=p.z)) && 
		    		(p.x <= (pointList[points[j]].x-pointList[points[i]].x) * (p.z-pointList[points[i]].z) / (pointList[points[j]].z-pointList[points[i]].z) + pointList[points[i]].x) )
		       c = !c;
		  }
		  return c;
	}
	
	
	
	public boolean ifCollide(Vector vector, Point3D[] pointList) {
		if((onPlane(vector.getOrigin(), pointList)>0) != (onPlane(vector.getNext(), pointList)>0)) {
			if((vector.getNext().z!=0) && (inPlaneXY(vector.getOrigin(), pointList) || inPlaneXY(vector.getNext(), pointList))) {
				return true;
			}
			if((vector.getNext().x!=0) && (inPlaneYZ(vector.getOrigin(), pointList) || inPlaneYZ(vector.getNext(), pointList))) {
				return true;
			}
			if((vector.getNext().y!=0) && (inPlaneXZ(vector.getOrigin(), pointList) || inPlaneXZ(vector.getNext(), pointList))) {
				return true;
			}
		}
		if((onPlane(vector.getOrigin(), pointList)<0) != (onPlane(vector.getNext(), pointList)<0)) {
			if((vector.getNext().z!=0) && (inPlaneXY(vector.getOrigin(), pointList) || inPlaneXY(vector.getNext(), pointList))) {
				return true;
			}
			if((vector.getNext().x!=0) && (inPlaneYZ(vector.getOrigin(), pointList) || inPlaneYZ(vector.getNext(), pointList))) {
				return true;
			}
			if((vector.getNext().y!=0) && (inPlaneXZ(vector.getOrigin(), pointList) || inPlaneXZ(vector.getNext(), pointList))) {
				return true;
			}
		}
		return false;
	}
	
	public Point3D[] getPoints(Point3D[] pointList) {
		Point3D[] ps = new Point3D[points.length];
		int count = 0;
		for(int id : points) {
			ps[count] = pointList[id];
			count++;
		}
		return ps;
	}
	
	public double getDistance(Point3D[] pointList) {
		double sumZ = 0;
		for(int id : points) {
			sumZ+=(pointList[id].z);
		}
		return Math.abs(sumZ/points.length);
	}
	
}
