package com.finalProject;

import java.awt.Graphics;

public class Article {
	
	private Plane[] planes;
	private Point3D[] points; 
	private Ref3D position = new Ref3D(0,0,0);
	
	public Article(Model m, Ref3D pos) {
		position = pos;
		planes = m.getPlanes();
		loadPoints(m.getRefs());
	}
	public Article(Model m) {
		position = new Ref3D(0.0,0.0,0.0);
		planes = m.getPlanes();
		loadPoints(m.getRefs());
	}
	private void loadPoints(Ref3D[] refs) {
		points = new Point3D[refs.length];
		int id = 0;
		for(Ref3D referencePoint : refs) {
			points[id] = referencePoint.toConcrete();
			points[id].add(position);
			id++;
		}
	}
	
	public void drawArticle(Graphics g3) {
		orderPlanes();
		for(Plane plane : planes) {
			plane.drawPlane(g3, points);
		}
	}
	
	public void orderPlanes() {
		double averageZs[] = new double[points.length];
		int id = 0;
		for(Plane plane : getPlanes()) {
 			averageZs[id] = plane.getDistance(points);
 			id++;
		}
		for(int f=0; f<planes.length/2; f++) {
			for(int i=0; i<planes.length-1; i++) {
				if(averageZs[i]<averageZs[i+1]) {
					Plane plane = planes[i];
					planes[i] = planes[i+1];
					planes[i+1] = plane;
				}
			}
		}
	}
	
	public Plane[] getPlanes() {
		return planes;
	}
	public Point3D[] getPoints() {
		return points;
	}

	public Ref3D getPosition() {
		position = new Ref3D(0,0,0);
		for(Point3D point : points) {
			position.add(point);
		}
		position.x/=points.length;
		position.y/=points.length;
		position.z/=points.length;
		return position;
	}
	public Plane getLowestPlane() {
		Plane plane = planes[0];
		for(int i=1; i<planes.length; i++) {
			if(plane.getDistance(points)>planes[i].getDistance(points)) {
				plane=planes[i];
			}
		}
		return plane;
	}
	
}
