package com.finalProject;

import java.awt.Color;

public class Block implements Model {
	
	
	
	private int l =0, w =0, h =0;
	private Color color = Color.WHITE;
	private Ref3D[] refs = new Ref3D[8];
	private Plane[] planes;
	
	public Block(int x, int y, int z) {
		l=z;
		w=x;
		h=y;
		setup();
	}
	public Block(int x, int y, int z, Color c) {
		l=z;
		w=x;
		h=y;
		color=c;
		setup();
	}
	public void setup() {
		planes=new Plane[6];
		refs[0] = new Ref3D(w,h,l);
		refs[1] = new Ref3D(w,h,-l);
		refs[2] = new Ref3D(w,-h,l);
		refs[3] = new Ref3D(w,-h,-l);
		refs[4] = new Ref3D(-w,h,l);
		refs[5] = new Ref3D(-w,h,-l);
		refs[6] = new Ref3D(-w,-h,l);
		refs[7] = new Ref3D(-w,-h,-l);
		
		int[] temp0 = {7,3,2, 6};
		planes[0] = new Plane(temp0);	//Top
		planes[0].setColor(color);
		
		int[] temp1 = {5,4,0,1};
		planes[1] = new Plane(temp1);	//Bottom
		planes[1].setColor(color);

		int[] temp2 = {5,7,3,1};
		planes[2] = new Plane(temp2);	//Front
		planes[2].setColor(color);

		int[] temp3 = {4,6,2,0};
		planes[3] = new Plane(temp3);	//Back
		planes[3].setColor(color);

		int[] temp4 = {7,5,4,6};
		planes[4] = new Plane(temp4);	//Left
		planes[4].setColor(color);

		int[] temp5 = {3,2,0,1};
		planes[5] = new Plane(temp5);	//Right
		planes[5].setColor(color);
	
	}
	
	public Plane[] getPlanes() {
		return planes;
	}
	public Ref3D[] getRefs() {
		return refs;
	}
	
	

}
