package com.finalProject;

public class Cube implements Model {
	
	int size = 100;

	Ref3D[] refs = new Ref3D[8];
	Plane[] planes;
	
	public Cube(int s) {
		size = s;
		setup();
	}
	public void setup() {
		planes=new Plane[6];
		refs[0] = new Ref3D(size,size,size);
		refs[1] = new Ref3D(size,size,-size);
		refs[2] = new Ref3D(size,-size,size);
		refs[3] = new Ref3D(size,-size,-size);
		refs[4] = new Ref3D(-size,size,size);
		refs[5] = new Ref3D(-size,size,-size);
		refs[6] = new Ref3D(-size,-size,size);
		refs[7] = new Ref3D(-size,-size,-size);
		
		int[] temp0 = {7,3,2, 6};
		planes[0] = new Plane(temp0);	//Top
		
		int[] temp1 = {5,4,0,1};
		planes[1] = new Plane(temp1);	//Bottom

		int[] temp2 = {5,7,3,1};
		planes[2] = new Plane(temp2);	//Front

		int[] temp3 = {4,6,2,0};
		planes[3] = new Plane(temp3);	//Back

		int[] temp4 = {7,5,4,6};
		planes[4] = new Plane(temp4);	//Left

		int[] temp5 = {3,2,0,1};
		planes[5] = new Plane(temp5);	//Right
	
	}
	
	public Plane[] getPlanes() {
		return planes;
	}
	public Ref3D[] getRefs() {
		return refs;
	}

}
