package com.finalProject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Random;

import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class CubeRunner implements RawGraph, Runnable, Controller {
    
    private boolean game = true;
    private static Dimension DIM = Toolkit.getDefaultToolkit().getScreenSize();
    private int levelNum = 100;
    private int stage=1;
    private boolean pKey = false;
    private Graph[] graphs;
    private boolean[] keys = new boolean[3];
    private Space3D space;
    private int speed = -3;
    private int level = 1;
    private Clip song;
    public static void main(String[] args) {
        new CubeRunner();
        
    }
    public CubeRunner() {
        JFrame f = new JFrame("CubeRunner - Daniel Berry");
        space = new Space3D();
        space.loadRawGraph(this);
        space.loadController(this);
        space.setFrameSize(DIM);
        space.loadFrame(f);
        space.loadSpace();
        setup();
        try{
            File soundFile = new File("com\\finalProject\\audio\\song.wav");
            AudioInputStream sound = AudioSystem.getAudioInputStream(soundFile);
            DataLine.Info info = new DataLine.Info(Clip.class, sound.getFormat());
            song = (Clip) AudioSystem.getLine(info);
            song.open(sound);
            song.addLineListener(new LineListener() {
              public void update(LineEvent event) {
               
              }
            });
            song.loop(Clip.LOOP_CONTINUOUSLY);
        }catch(Exception x) {x.printStackTrace();   }
    }
    
    private boolean leaned = false;
    private int rrotateVal = 0, lrotateVal = 0;
    @Override
    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if(keyCode==KeyEvent.VK_RIGHT) {
            if(!leaned) {
                leaned=true;
                Transform.rotateZ(graphs[0],-1);
                rrotateVal++;
            }
            keys[0] = true;
        }
        if(keyCode==KeyEvent.VK_LEFT) {
            if(!leaned) {
                leaned=true;
                Transform.rotateZ(graphs[0],1);
                lrotateVal--;
            }
            keys[1] = true;
        }
        if(keyCode==KeyEvent.VK_UP && !keys[2]) {
            keys[2]=true;
            speed-=2;
        }
        
        if(keyCode==KeyEvent.VK_SPACE) {
            if(stage==3) {
                stage=1;
                levelNum=100;
                setup();
                speed=-3;
                level = 1;
                game=true;
            }
        }
        
        
        if(keyCode==KeyEvent.VK_ENTER) {
            if(stage==1) {
                stage=2;
                Thread t = new Thread(this);
                t.start();
            }
        }
        
        if(keyCode==KeyEvent.VK_P) {
            if(pKey) {
                songin(1);
            }
            else if(!pKey) {
                songin(0);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int keyCode = e.getKeyCode();
        if(keyCode==KeyEvent.VK_RIGHT) {
            if(leaned) {
                Transform.rotateZ(graphs[0],rrotateVal);
                rrotateVal=0;
            }
            keys[0] = false;
        }
        if(keyCode==KeyEvent.VK_LEFT) {
            if(leaned) {
                Transform.rotateZ(graphs[0],lrotateVal);
                lrotateVal=0;
            }
            keys[1] = false;
        }
        if((keys[0] && keys[1])==false) {
            leaned=false;
        }

        if(keyCode==KeyEvent.VK_UP && keys[2]) {
            keys[2]=false;
            speed+=2;
        }

        if(keyCode==KeyEvent.VK_UP && keys[2]) {
            keys[2]=false;
            speed+=2;
        }
        if(keyCode==KeyEvent.VK_P) {
            if(pKey) {
                pKey=false;
            }
            else if(!pKey) {
                pKey=true;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        // TODO Auto-generated method stub
        int xZero = DIM.width/2, yZero = DIM.height/2;
        if(stage==1) {
            if(e.getX()>xZero-135 && e.getX()<xZero+65 && e.getY()>yZero-40 && e.getX()<xZero+60) {
                stage=2;
                Thread t = new Thread(this);
                t.start();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        // TODO Auto-generated method stub
        
    }
    
    public void mouseMoved(MouseEvent e) {
        
    }
    
    
    public void setRawGraph(RawGraph map) {
        
    }
    
    public Force[] getForces() {
        
        return null;
    }
    
    public void run() {
        while(game) {
            if(!Transform.translateZ(graphs[0], speed))gameOver();
            move();
            try {
                Thread.sleep(1);
            }catch(Exception e) {
                
            }
        }
    }
    
    public void move() {
        if(keys[0]) {
            if(!Transform.translateX(graphs[0], -5)) {
                Transform.rotateY(graphs[0], 2);
                gameOver();
            }
        }
        else if(keys[1]) {
            if(!Transform.translateX(graphs[0], 5)) {
                Transform.rotateY(graphs[0], -2);
                gameOver();
            }
        }
        
        
        if(graphs[0].getArticles()[levelNum-5].getPosition().z<-1000) {
            speed-=1;
            levelNum+=20;
            level++;
            setup();
            space.loadRawGraph(this);
        }
    }
    
    public Graph[] getGraphs() {
        
        return graphs;
    }
    
    public void setup() {
        graphs = new Graph[1];
        graphs[0] = new Graph();
        Random r = new Random();
        int next = 300;
        for(int i=0; i<levelNum; i++) {
            Article a = new Article(new Block((r.nextInt()%50)+5,(r.nextInt()%50)+5,5, new Color(Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255))), new Ref3D(r.nextInt()%300,r.nextInt()%20,next));
            graphs[0].add(a);
            next += Math.abs(r.nextInt()%100);
        }
        Article b = new Article(new Block(10,600,next*3, new Color(Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255))), new Ref3D(-300,0,next/2));
        graphs[0].add(b);
        b = new Article(new Block(10,600,next*3, new Color(Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255))), new Ref3D(300,0,next/2));
        graphs[0].add(b);
        b = new Article(new Block(600,10,next*3, new Color(Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255))), new Ref3D(0,-50,next/2));
        graphs[0].add(b);
        b = new Article(new Block(600,10,next*3, new Color(Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255),Math.abs(r.nextInt()%255))), new Ref3D(0,50,next/2));
        graphs[0].add(b);
    }
    
    
    public void gameOver() {
        Transform.rotateZ(graphs[0], -2);
        game=false;
        stage = 3;
    }
    @Override
    public void setBMap(Graphics g3) {
        
    }
    @Override
    public void setAMap(Graphics g3) {
        // TODO Auto-generated method stub
        if(stage==1) {
            g3.setColor(Color.BLACK);
            g3.fillRect(-DIM.width/2,-DIM.height/2, DIM.width, DIM.height);
            Image explosion = new ImageIcon("com\\finalProject\\images\\lightning.gif").getImage();
            g3.drawImage(explosion,-DIM.width/2,-DIM.height/2, DIM.width, DIM.height, null);
            g3.setColor(Color.GRAY);
            g3.fill3DRect(-300,-200, 600, 400, true);
            g3.setFont(new Font("TimesRoman", Font.BOLD, 50));
            g3.setColor(Color.BLACK);
            g3.drawString("CubeRunner" , -272, -140);       
            g3.setColor(Color.RED);
            g3.drawString("CubeRunner" , -270, -140);       
            g3.setColor(Color.MAGENTA);
            g3.fill3DRect(-135,-40, 200, 100, true);
            g3.setColor(Color.BLACK);
            g3.setFont(new Font("TimesRoman", Font.BOLD, 40));
            g3.drawString("START" , -101, 10);              
            g3.setColor(Color.RED);
            g3.setFont(new Font("TimesRoman", Font.BOLD, 40));
            g3.drawString("START" , -100, 10);      
            

            g3.setFont(new Font("TimesRoman", Font.BOLD, 15));
            g3.setColor(Color.WHITE);
            g3.drawString("Programming and Design by: Daniel Berry" , -50, 100);        
            g3.drawString("Music by: Dj yanni - Rhythm is a Bass" , -50, 130);     
            g3.drawString("Press 'p' to stop and start the music." , -50, 160);      
        }
        if(stage==2) {
            g3.setColor(Color.RED);
            g3.fill3DRect((-DIM.width/2)+8,(-DIM.height/2)+8,80,24, true);
            g3.setFont(new Font("TimesRoman", Font.PLAIN, 20));
            g3.setColor(Color.WHITE);
            g3.drawString("Level: " + level, (-DIM.width/2)+12, (-DIM.height/2)+27);
        }
        if(stage==3) {
            Image explosion = new ImageIcon("com\\finalProject\\images\\explosion.gif").getImage();
            g3.drawImage(explosion,-650,-650,1300, 1300, null);
            g3.setColor(Color.black);
            g3.setFont(new Font("TimesRoman", Font.BOLD, 50));
            g3.drawString("Game Over", -100, -100);
            g3.drawString("Press <Space> to continue.", -200, 50);
        }
        
    }
    public void songin(int i) {
        if(i==1) {
            song.loop(Clip.LOOP_CONTINUOUSLY);
        }else if(i==0) {
            song.stop();
        }
    }
    
}
