package com.finalProject;

import java.awt.Point;

public class Point3D {
	
	public double x = 0.0, y = 0.0, z = 0.0;
	private int x2D = 0, y2D = 0;
	
	public Point3D(double a, double b, double c) {
		x=a;
		y=b;
		z=c;
	}
	
	public void add(Point3D p) {
		x+=p.x;
		y+=p.y;
		z+=p.z;
		render();
	}
	public void add(Ref3D p) {
		x+=p.x;
		y+=p.y;
		z+=p.z;
		render();
	}
	
	private void render() {
		double ZScale = (Constant.FOCAL/(Constant.FOCAL+z));
		if(z<-Constant.FOCAL) ZScale+=-(ZScale*Constant.FOCAL);
		
		x2D = (int)(ZScale*x);
		y2D = (int)(ZScale*y);
	}
	public Point getPoint2D() {
		render();
		return new Point(x2D, y2D);
	}
	
	public String toString() {
		return "(" + x + ", " + y + ", " + z + ")";
	}
	
}
