package com.finalProject;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JPanel;

public class Space3D extends JPanel implements Runnable {
	private static final long serialVersionUID = 1L;
	
	
	
	//Setters
	private Dimension DIM = new Dimension(1000,500);
	private int sleepTimer = 4;
	private int refreshRate = 15;
	
	//Trackers
	private boolean active = true;
	private int refresh = 0;
	private BufferedImage buffer;
	private Graphics g3;
	private RawGraph rawgraph;
	private Controller controller;
	JFrame frame;
	
	
	public Space3D() {
		frame = new JFrame();
		buffer = new BufferedImage(DIM.width, DIM.height, BufferedImage.TYPE_INT_RGB);
		g3 = buffer.getGraphics();
	}
	
	public void loadSpace() {
		JFrame f=frame;
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.pack();
		f.add(this);
		try {
			f.addKeyListener(controller);
			f.addMouseListener(controller);
			f.addMouseMotionListener(controller);
		}catch(Exception e) {
			System.out.println("A contoller must be specified with 'loadController(Controller c)' before 'loadSpace()' is called.");
			e.printStackTrace();
		}
		f.setResizable(false);
		f.setSize(DIM);
		g3.translate(DIM.width/2, DIM.height/2);
		f.setVisible(true);
		Thread t = new Thread(this);
		t.start();
	}
	
	public void loadFrame(JFrame f) {
		frame = f;
	}
	
	public void loadRawGraph(RawGraph map) {
		rawgraph = map;
	}
	public void loadController(Controller c) {
		controller = c;
		try {
			c.setRawGraph(rawgraph);
		}catch(Exception e) {
			System.out.println("The method 'loadRawGraph(RawGraph map)' must be called before 'loadController(Controller c)' in a client class.");
			e.printStackTrace();
		}
	}
	public void setFrameSize(Dimension d) {
		DIM = d;
		buffer = new BufferedImage(DIM.width, DIM.height, BufferedImage.TYPE_INT_RGB);
		g3 = buffer.getGraphics();
	}
	
	
	public void update(Graphics g) {
		paint(g);
	}
	public void paint(Graphics g) {
		Graphics2D g2= (Graphics2D)g;
		g2.drawImage(buffer,0,0,null);
	}
	
	public void make() {
		g3.setColor(Color.BLACK);
		g3.fillRect((0-(DIM.width/2)),(0-(DIM.height/2)), DIM.width, DIM.height);
		controller.setBMap(g3);
		
		//drawRawGraph(g3);
		
		for(Graph graph : rawgraph.getGraphs()) {
			graph.drawGraph(g3);
		}
		
		controller.setAMap(g3);
		
		repaint();
	}
	
	public void run() {
		while(active) {
			
			if(refresh>=refreshRate) {
				make();
				refresh=0;
			}refresh++;
			
			try {
				Thread.sleep(sleepTimer);
			}catch(Exception e) {
				e.printStackTrace();
			}
		}
	}
	
	public void drawRawGraph(Graphics g3) {
		ArrayList<Plane> planes = new ArrayList<Plane>();
		ArrayList<Point3D[]> points = new ArrayList<Point3D[]>();
		for(Graph graph : rawgraph.getGraphs()) {
			for(Article article : graph.getArticles()) {
				for(Plane plane : article.getPlanes()) {
					planes.add(plane);
					points.add(article.getPoints());
				}
			}
		}
		
		for(int i=0; i<planes.size(); i++) {
			for(int f = 0; f<planes.size()-1; f++) {
				double distanceA = ((Plane) planes.get(f)).getDistance(((Point3D[]) points.get(f)));
				double distanceB = ((Plane) planes.get(f+1)).getDistance(((Point3D[]) points.get(f+1)));
				if(distanceA>distanceB) {
					Plane p = (Plane) planes.get(f);
					planes.set(f, planes.get(f+1));
					planes.set(f+1, p);
				}
			}
		}
		
		int id = 0;
		for(Plane plane : planes) {
			plane.drawPlane(g3, points.get(id));
			id++;
		}
	}

}

