package com.finalProject;

public class Transform {
	
	public static boolean translateX(Graph graph, int dx) {
		for(Article article : (graph.getArticles())) {
			for(Plane plane : article.getPlanes()) {
				if(plane.ifCollide(new Vector(new Point3D(0,0,-Constant.FOCAL), new Ref3D(dx,0,0)), article.getPoints())) 
					return false;
			}
		}
		for(Article article : (graph.getArticles())) {
			for(Point3D point : article.getPoints()) {
				point.add(new Ref3D(dx,0,0));
			}
		}
		return true;
	}
	
	
	public static boolean translateY(Graph graph, int dy) {
		for(Article article : (graph.getArticles())) {
			for(Plane plane : article.getPlanes()) {
				if(plane.ifCollide(new Vector(new Point3D(0,0,-Constant.FOCAL), new Ref3D(0,dy,0)), article.getPoints())) 
					return false;
			}
		}
		for(Article article : (graph.getArticles())) {
			for(Point3D point : article.getPoints()) {
				point.add(new Ref3D(0,dy,0));
			}
		}
		return true;
	}
	
	public static boolean translateZ(Graph graph, int dz) {
		for(Article article : (graph.getArticles())) {
			for(Plane plane : article.getPlanes()) {
				if(plane.ifCollide(new Vector(new Point3D(0,0,-Constant.FOCAL), new Ref3D(0,0,dz)), article.getPoints())) 
					return false;
			}
		}
		for(Article article : (graph.getArticles())) {
			for(Point3D point : article.getPoints()) {
				point.add(new Ref3D(0,0,dz));
			}
		}
		return true;
	}
	
	public static void rotateX(Graph graph, double deg) {
		double CosVal = (float)Math.cos(Math.toRadians(deg)); 
		double SinVal = (float)Math.sin(Math.toRadians(deg));
		
		for(Article article: graph.getArticles()) {
			for(Point3D point : article.getPoints()) {
					point.add(new Ref3D(0,0,Constant.FOCAL));
					double NewY = (((CosVal * point.y) - (SinVal * point.z)));
					double NewZ = (((CosVal * point.z) + (SinVal * point.y)));
					point.add(new Ref3D(0,NewY-point.y,NewZ-point.z));
					point.add(new Ref3D(0,0,-Constant.FOCAL));
			}
		}
	}
	
	public static void rotateY(Graph graph, double deg) {
		double CosVal = (float)Math.cos(Math.toRadians(deg)); 
		double SinVal = (float)Math.sin(Math.toRadians(deg));
		
		for(Article article: graph.getArticles()) {
			for(Point3D point : article.getPoints()) {
					point.add(new Ref3D(0,0,Constant.FOCAL));
					double NewX = (((CosVal * point.x) - (SinVal * point.z)));
					double NewZ = (((CosVal * point.z) + (SinVal * point.x)));
					point.add(new Ref3D(NewX-point.x,0,NewZ-point.z));
					point.add(new Ref3D(0,0,-Constant.FOCAL));
			}
		}
	}	
	
	public static void rotateZ(Graph graph, double deg) {
		double CosVal = (float)Math.cos(Math.toRadians(deg)); 
		double SinVal = (float)Math.sin(Math.toRadians(deg));
		
		for(Article article: graph.getArticles()) {
			for(Point3D point : article.getPoints()) {
					double NewX = (((CosVal * point.x) - (SinVal * point.y)));
					double NewZ = (((CosVal * point.y) + (SinVal * point.x)));
					point.add(new Ref3D(NewX-point.x,NewZ-point.y,0));
			}
		}
	}
	
	
}
