/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha;

import com.Alpha.BoundingBox;
import com.Alpha.Physics;
import com.Alpha.Vector3f;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Article {
    private int bufferId;
    private FloatBuffer data;
    public Vector3f dMove = new Vector3f();
    private boolean cullFaces = true;
    private Texture texture;
    private String name;
    private BoundingBox[] boxes;
    public Vector3f position;
    private short numOfPlanes;
    private boolean dynamicBoundingBoxes;
    private Physics physics;
    private Vector3f angle = new Vector3f();
    private float mass;

    public Article(String model, Vector3f p) {
        this.position = p;
        this.setMass(10.0f);
        this.setPhysics(new Physics());
        this.loadArticle(model);
    }

    private void loadArticle(String f) {
        try {
            this.bufferId = GL15.glGenBuffers();
            BufferedReader bR = new BufferedReader(new FileReader(new File(f)));
            bR.readLine().equals("#DanModelFormat");
            this.name = bR.readLine();
            String line = bR.readLine();
            if (!line.equals("null")) {
                this.loadTexture(line);
            }
            this.numOfPlanes = (short)Integer.parseInt(bR.readLine());
            this.data = BufferUtils.createFloatBuffer(this.numOfPlanes * 24);
            float[] points = new float[this.numOfPlanes * 24];
            this.dynamicBoundingBoxes = bR.readLine().toLowerCase().equals("t");
            this.cullFaces = bR.readLine().toLowerCase().equals("t");
            line = bR.readLine();
            Vector3f normal = new Vector3f();
            int i = 0;
            while (i < this.numOfPlanes * 3) {
                line = bR.readLine();
                points[i * 8 + 0] = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                points[i * 8 + 1] = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                points[i * 8 + 2] = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                line = bR.readLine();
                points[i * 8 + 6] = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                points[i * 8 + 7] = Float.parseFloat(line.substring(line.indexOf("\\") + 2));
                if (i % 3 == 2) {
                    Vector3f[] p = new Vector3f[]{new Vector3f(points[(i - 2) * 8 + 0], points[(i - 2) * 8 + 1], points[(i - 2) * 8 + 2]), new Vector3f(points[(i - 1) * 8 + 0], points[(i - 1) * 8 + 1], points[(i - 1) * 8 + 2]), new Vector3f(points[i * 8 + 0], points[i * 8 + 1], points[i * 8 + 2])};
                    normal = this.calculateNormal(p);
                    points[(i - 2) * 8 + 3] = normal.x;
                    points[(i - 2) * 8 + 4] = normal.y;
                    points[(i - 2) * 8 + 5] = normal.z;
                    points[(i - 1) * 8 + 3] = normal.x;
                    points[(i - 1) * 8 + 4] = normal.y;
                    points[(i - 1) * 8 + 5] = normal.z;
                    points[i * 8 + 3] = normal.x;
                    points[i * 8 + 4] = normal.y;
                    points[i * 8 + 5] = normal.z;
                }
                ++i;
            }
            this.data.put(points);
            this.data.flip();
            GL15.glBindBuffer(34962, this.bufferId);
            GL15.glBufferData(34962, this.data, 35044);
            if (bR.readLine().equals("BoundingBoxes:") && !this.dynamicBoundingBoxes) {
                ArrayList<BoundingBox> boxList = new ArrayList<BoundingBox>();
                line = bR.readLine();
                while (line != null) {
                    Vector3f top = new Vector3f();
                    top.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                    top.y = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                    top.z = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                    line = bR.readLine();
                    Vector3f bottom = new Vector3f();
                    bottom.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                    bottom.y = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                    bottom.z = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                    BoundingBox b = new BoundingBox(top, bottom, this.position);
                    boxList.add(b);
                    line = bR.readLine();
                }
                this.boxes = new BoundingBox[boxList.size()];
                int i2 = 0;
                while (i2 < this.boxes.length) {
                    this.boxes[i2] = (BoundingBox)boxList.get(i2);
                    i2 = (short)(i2 + 1);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void move() {
        GL11.glTranslatef(this.position.x, this.position.y, this.position.z);
        GL11.glRotatef(this.angle.x, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.angle.y, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.angle.z, 0.0f, 0.0f, 1.0f);
    }

    public void tick() {
        this.position.x += this.dMove.x;
        this.position.y += this.dMove.y;
        this.position.z += this.dMove.z;
    }

    private void loadTexture(String f) {
        try {
            this.texture = TextureLoader.getTexture("png", new FileInputStream(new File(f)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                this.texture = TextureLoader.getTexture("png", new FileInputStream(new File(f)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.texture = null;
    }

    private Vector3f calculateNormal(Vector3f[] points) {
        Vector3f u = new Vector3f(points[1].x - points[0].x, points[1].y - points[0].y, points[1].z - points[0].z);
        Vector3f v = new Vector3f(points[2].x - points[0].x, points[2].y - points[0].y, points[2].z - points[0].z);
        return new Vector3f(u.z * v.y - u.y * v.z, u.x * v.z - u.z * v.x, u.y * v.x - u.x * v.y);
    }

    public BoundingBox next(Vector3f v, short id) {
        return new BoundingBox(this.boxes[id].getTop(), this.boxes[id].getBottom(), this.boxes[id].getOffset().add(v));
    }

    public float getDistance(Vector3f o) {
        float distance = 0.0f;
        distance += (o.x - this.position.x) * (o.x - this.position.x);
        distance += (o.y - this.position.y) * (o.y - this.position.y);
        distance += (o.z - this.position.z) * (o.z - this.position.z);
        distance = (float)Math.sqrt(distance);
        return distance;
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setDMove(Vector3f v) {
        this.dMove = v;
    }

    public Vector3f getDMove() {
        return this.dMove;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public boolean getCullFaces() {
        return this.cullFaces;
    }

    public Physics getPhysics() {
        return this.physics;
    }

    public void setPhysics(Physics physics) {
        this.physics = physics;
    }

    public short getNumOfPlanes() {
        return this.numOfPlanes;
    }

    public BoundingBox[] getBoxes() {
        return this.boxes;
    }

    public void setBoxes(BoundingBox[] boxes) {
        this.boxes = boxes;
    }

    public String toString() {
        return this.name;
    }

    public Vector3f getAngle() {
        return this.angle;
    }

    public void setAngle(Vector3f angle) {
        this.angle = angle;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }
}

