/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha;

import com.Alpha.Vector3f;

public class BoundingBox {
    private Vector3f top;
    private Vector3f bottom;
    private Vector3f offset;

    public BoundingBox(Vector3f t, Vector3f b, Vector3f o) {
        this.top = t;
        this.bottom = b;
        this.offset = o;
    }

    public BoundingBox(Vector3f[] p, Vector3f o) {
        this.top = p[0];
        this.bottom = p[0];
        int i = 0;
        while (i < p.length) {
            if (p[i].x > this.top.x) {
                this.top = new Vector3f(p[i].x, this.top.y, this.top.z);
            } else if (p[i].x < this.bottom.x) {
                this.bottom = new Vector3f(p[i].x, this.bottom.y, this.bottom.z);
            }
            if (p[i].y > this.top.y) {
                this.top = new Vector3f(this.top.x, p[i].y, this.top.z);
            } else if (p[i].y < this.bottom.y) {
                this.bottom = new Vector3f(this.bottom.x, p[i].y, this.bottom.z);
            }
            if (p[i].z > this.top.z) {
                this.top = new Vector3f(this.top.x, this.top.y, p[i].z);
            } else if (p[i].z < this.bottom.z) {
                this.bottom = new Vector3f(this.bottom.x, this.bottom.y, p[i].z);
            }
            ++i;
        }
        this.offset = o;
    }

    public Vector3f getTop() {
        return this.top;
    }

    public Vector3f getBottom() {
        return this.bottom;
    }

    public void setOffset(Vector3f o) {
        this.offset = o;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    public boolean contains(Vector3f p) {
        return p.x < this.top.x + this.offset.x && p.x > this.bottom.x + this.offset.x && p.y < this.top.y + this.offset.y && p.y > this.bottom.y + this.offset.y && p.z < this.top.z + this.offset.z && p.z > this.bottom.z + this.offset.z;
    }

    public boolean intersects(BoundingBox b) {
        Vector3f to = b.getTop().add(b.getOffset());
        Vector3f bo = b.getBottom().add(b.getOffset());
        return this.contains(to) || this.contains(bo) || this.contains(new Vector3f(bo.x, bo.y, to.z)) || this.contains(new Vector3f(bo.x, to.y, to.z)) || this.contains(new Vector3f(bo.x, to.y, bo.z)) || this.contains(new Vector3f(to.x, to.y, bo.z)) || this.contains(new Vector3f(to.x, bo.y, to.z)) || this.contains(new Vector3f(to.x, bo.y, bo.z)) || b.contains(new Vector3f(this.bottom.add((Vector3f)this.offset).x, this.bottom.add((Vector3f)this.offset).y, this.top.add((Vector3f)this.offset).z)) || b.contains(new Vector3f(this.bottom.add((Vector3f)this.offset).x, this.top.add((Vector3f)this.offset).y, this.top.add((Vector3f)this.offset).z)) || b.contains(new Vector3f(this.bottom.add((Vector3f)this.offset).x, this.top.add((Vector3f)this.offset).y, this.bottom.add((Vector3f)this.offset).z)) || b.contains(new Vector3f(this.top.add((Vector3f)this.offset).x, this.top.add((Vector3f)this.offset).y, this.bottom.add((Vector3f)this.offset).z)) || b.contains(new Vector3f(this.top.add((Vector3f)this.offset).x, this.bottom.add((Vector3f)this.offset).y, this.top.add((Vector3f)this.offset).z)) || b.contains(new Vector3f(this.top.add((Vector3f)this.offset).x, this.bottom.add((Vector3f)this.offset).y, this.bottom.add((Vector3f)this.offset).z)) || b.contains(this.top.add(this.offset)) || b.contains(this.bottom.add(this.offset));
    }

    public boolean intersects2(BoundingBox b) {
        Vector3f to = b.getTop().add(b.getOffset());
        Vector3f bo = b.getBottom().add(b.getOffset());
        return to.x >= this.bottom.x + this.offset.x && to.y >= this.bottom.y + this.offset.y && to.z >= this.bottom.z + this.offset.z && this.top.x + this.offset.x >= bo.x && this.top.y + this.offset.y >= bo.y && this.top.z + this.offset.z >= bo.z;
    }

    public String toString() {
        return "TOP:" + this.top.toString() + "\nBottom:" + this.bottom.toString();
    }
}

