/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha;

import com.Alpha.Article;
import com.Alpha.Vector3f;
import java.awt.Point;
import java.util.Random;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;

public class Module {
    private Article[] articles;
    private boolean[] keys = new boolean[11];
    public float walkingAcceleration = 0.06f;
    private final float defaultWalkingAcceleration = 0.06f;
    public float frictionAcceleration = 0.03f;
    private final float defaultFrictionAcceleration = 0.03f;
    public float maxWalkingSpeed = 0.3f;
    private final float defaultMaxWalkingSpeed = 0.6f;
    public float gravityAcceleration = -0.05f;
    private final float defaultGravityAcceleration = -0.05f;
    public boolean falling = false;
    private short cameraArticleId;
    boolean explode = false;
    Point mp = new Point();

    public static void main(String[] args) {
        new Module();
    }

    public Module() {
        try {
            Display.setDisplayMode(new DisplayMode(1000, 500));
            Display.setVSyncEnabled(true);
            Display.setResizable(false);
            Display.setTitle("Roget Moon");
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            Display.destroy();
            System.exit(0);
        }
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(70.0f, Display.getWidth() / Display.getHeight(), 0.001f, 150.0f);
        GL11.glPopAttrib();
        GL11.glMatrixMode(5888);
        GL11.glEnable(2929);
        GL11.glEnable(3553);
        GL11.glFrontFace(2304);
        GL11.glEnable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3152, 4354);
        this.articles = new Article[8];
        this.articles[0] = new Article("res\\models\\box.dmf", new Vector3f(-2.0f, 10.0f, 0.0f));
        this.articles[1] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, -1.0f, -0.0f));
        this.articles[2] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 0.0f, 0.0f));
        this.articles[3] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 1.0f, 0.0f));
        this.articles[4] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 2.0f, 0.0f));
        this.articles[5] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 3.0f, 0.0f));
        this.articles[6] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 4.0f, 0.0f));
        this.articles[7] = new Article("res\\models\\grass.dmf", new Vector3f(0.0f, -2.5f, 0.0f));
        Mouse.setGrabbed(true);
        this.loop();
        int i = 0;
        while (i < this.articles.length) {
            GL15.glDeleteBuffers(this.articles[i].getBufferId());
            ++i;
        }
        Display.destroy();
    }

    private void loop() {
        while (!Display.isCloseRequested()) {
            GL11.glClear(16640);
            GL11.glLoadIdentity();
            this.moveCamera();
            this.render();
            this.logInput();
        }
    }

    private void render() {
        int i = 0;
        while (i < this.articles.length) {
            GL11.glPushMatrix();
            if (this.articles[i].getCullFaces()) {
                GL11.glEnable(2884);
            } else {
                GL11.glDisable(2884);
            }
            this.articles[i].move();
            if (this.articles[i].getTexture() != null) {
                this.articles[i].getTexture().bind();
            }
            GL15.glBindBuffer(34962, this.articles[i].getBufferId());
            GL11.glVertexPointer(3, 5126, 32, 0L);
            GL11.glNormalPointer(5126, 32, 12L);
            GL11.glTexCoordPointer(2, 5126, 32, 24L);
            GL11.glEnableClientState(32884);
            GL11.glEnableClientState(32885);
            GL11.glEnableClientState(32888);
            GL11.glDrawArrays(4, 0, this.articles[i].getNumOfPlanes() * 3);
            GL11.glDisableClientState(32888);
            GL11.glDisableClientState(32885);
            GL11.glDisableClientState(32884);
            GL11.glPopMatrix();
            ++i;
        }
        Display.update();
        Display.sync(90);
    }

    private void logInput() {
        this.keys[0] = Keyboard.isKeyDown(17);
        this.keys[1] = Keyboard.isKeyDown(30);
        this.keys[2] = Keyboard.isKeyDown(31);
        this.keys[3] = Keyboard.isKeyDown(32);
        this.keys[4] = Keyboard.isKeyDown(57);
        this.keys[5] = Keyboard.isKeyDown(15);
        this.keys[6] = Keyboard.isKeyDown(42);
        this.keys[7] = Keyboard.isKeyDown(29);
        this.keys[8] = Keyboard.isKeyDown(56);
        this.keys[9] = Keyboard.isKeyDown(16);
        this.keys[10] = Keyboard.isKeyDown(18);
        if (Keyboard.isKeyDown(1)) {
            Display.destroy();
            System.exit(0);
        }
        if (this.keys[0] && Math.abs(this.articles[this.cameraArticleId].dMove.z) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.z -= this.walkingAcceleration;
        }
        if (this.keys[2] && Math.abs(this.articles[this.cameraArticleId].dMove.z) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.z += this.walkingAcceleration;
        }
        if (this.keys[1] && Math.abs(this.articles[this.cameraArticleId].dMove.x) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.x += this.walkingAcceleration;
        }
        if (this.keys[3] && Math.abs(this.articles[this.cameraArticleId].dMove.x) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.x -= this.walkingAcceleration;
        }
        if (this.keys[4] && Math.abs(this.articles[this.cameraArticleId].dMove.y) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.y += this.walkingAcceleration;
        }
        if (this.keys[6] && Math.abs(this.articles[this.cameraArticleId].dMove.y) < this.maxWalkingSpeed) {
            this.articles[this.cameraArticleId].dMove.y -= this.walkingAcceleration;
        }
        if ((double)this.articles[this.cameraArticleId].dMove.y > 1.0E-4) {
            this.articles[this.cameraArticleId].dMove.y -= this.frictionAcceleration;
        } else if ((double)this.articles[this.cameraArticleId].dMove.y < -1.0E-4) {
            this.articles[this.cameraArticleId].dMove.y += this.frictionAcceleration;
        }
        if (this.keys[7] && !this.explode) {
            this.explode = true;
            Random r = new Random();
            int i = 0;
            while (i < this.articles.length - 1) {
                this.articles[i].dMove.x = r.nextFloat() % 2.0f * (float)(r.nextInt() % 2 == 0 ? 1 : -1);
                this.articles[i].dMove.y = Math.abs(r.nextFloat() % 3.0f);
                this.articles[i].dMove.z = r.nextFloat() % 2.0f * (float)(r.nextInt() % 2 == 0 ? 1 : -1);
                ++i;
            }
        } else if (this.explode && !this.keys[7]) {
            this.explode = false;
        }
        this.mp.x += Mouse.getDX() / 8;
        this.mp.y -= Mouse.getDY() / 8;
        if (this.mp.y >= 85) {
            this.mp.y = 85;
        }
        if (this.mp.y <= -70) {
            this.mp.y = -70;
        }
        if (this.mp.x >= 360) {
            this.mp.x -= 360;
        }
        if (this.mp.x <= -360) {
            this.mp.x += 360;
        }
        if (this.keys[4] && !this.falling) {
            this.articles[this.cameraArticleId].dMove.y = 0.4f;
            this.falling = true;
        }
        int i = 0;
        while (i < this.articles.length - 1) {
            if (this.articles[i].dMove.y > -0.9f) {
                this.articles[i].dMove.y += this.gravityAcceleration;
            }
            if ((double)Math.abs(this.articles[i].dMove.x) < 0.01) {
                this.articles[i].dMove.x = 0.0f;
            }
            if ((double)Math.abs(this.articles[i].dMove.y) < 0.01) {
                this.articles[i].dMove.y = 0.0f;
            }
            if ((double)Math.abs(this.articles[i].dMove.z) < 0.01) {
                this.articles[i].dMove.z = 0.0f;
            }
            if ((double)this.articles[i].dMove.z > 1.0E-4) {
                this.articles[i].dMove.z -= this.frictionAcceleration;
            } else if ((double)this.articles[i].dMove.z < -1.0E-4) {
                this.articles[i].dMove.z += this.frictionAcceleration;
            }
            if ((double)this.articles[i].dMove.x > 1.0E-4) {
                this.articles[i].dMove.x -= this.frictionAcceleration;
            } else if ((double)this.articles[i].dMove.x < -1.0E-4) {
                this.articles[i].dMove.x += this.frictionAcceleration;
            }
            ++i;
        }
        this.articles[this.cameraArticleId].setAngle(new Vector3f(0.0f, this.mp.x, 0.0f));
        if (this.keys[5]) {
            this.cameraArticleId = this.cameraArticleId == 5 ? (short)0 : (short)(this.cameraArticleId + 1);
            this.mp.x = (int)this.articles[this.cameraArticleId].getAngle().y;
        }
    }

    public void moveCamera() {
        int i = 0;
        while (i < this.articles.length) {
            this.collideX(this.articles[i], i);
            this.articles[i].position.x += this.articles[i].dMove.x;
            int k = 0;
            while (k < this.articles[i].getBoxes().length) {
                this.articles[i].getBoxes()[k].setOffset(this.articles[i].getBoxes()[k].getOffset().add(new Vector3f(this.articles[i].dMove.x, 0.0f, 0.0f)));
                k = (byte)(k + 1);
            }
            this.collideY(this.articles[i], i);
            this.articles[i].position.y += this.articles[i].dMove.y;
            k = 0;
            while (k < this.articles[i].getBoxes().length) {
                this.articles[i].getBoxes()[k].setOffset(this.articles[i].getBoxes()[k].getOffset().add(new Vector3f(0.0f, this.articles[i].dMove.y, 0.0f)));
                k = (byte)(k + 1);
            }
            this.collideZ(this.articles[i], i);
            this.articles[i].position.z += this.articles[i].dMove.z;
            k = 0;
            while (k < this.articles[i].getBoxes().length) {
                this.articles[i].getBoxes()[k].setOffset(this.articles[i].getBoxes()[k].getOffset().add(new Vector3f(0.0f, 0.0f, this.articles[i].dMove.z)));
                k = (byte)(k + 1);
            }
            ++i;
        }
        GL11.glRotatef(30.0f, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef((float)(270 - this.mp.x) + 0.0f, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(-this.articles[this.cameraArticleId].getPosition().x - (float)(Math.cos(Math.toRadians(this.mp.x)) * 4.0), -this.articles[this.cameraArticleId].getPosition().y - 2.0f, -this.articles[this.cameraArticleId].getPosition().z + (float)(Math.sin(Math.toRadians(this.mp.x)) * 4.0));
    }

    private void collideX(Article a, int id) {
        block13: {
            block12: {
                if (!(a.dMove.x < 0.0f)) break block12;
                float step = -0.01f;
                while (step >= a.dMove.x) {
                    int i = 0;
                    while (i < this.articles.length) {
                        if (this.articles[i].getDistance(a.position) < 20.0f && i != id) {
                            int k = 0;
                            while (k < this.articles[i].getBoxes().length) {
                                short t = 0;
                                while (t < a.getBoxes().length) {
                                    if (a.next(new Vector3f(step, 0.0f, 0.0f), t).intersects2(this.articles[i].getBoxes()[k])) {
                                        a.getPhysics().collideX(this, step, a, this.articles[i]);
                                    }
                                    t = (short)(t + 1);
                                }
                                k = (short)(k + 1);
                            }
                        }
                        i = (short)(i + 1);
                    }
                    step = (float)((double)step - 0.01);
                }
                break block13;
            }
            if (!(a.dMove.x > 0.0f)) break block13;
            float step = 0.01f;
            while (step <= a.dMove.x) {
                int i = 0;
                while (i < this.articles.length) {
                    if (this.articles[i].getDistance(a.position) < 20.0f && i != id) {
                        int k = 0;
                        while (k < this.articles[i].getBoxes().length) {
                            short t = 0;
                            while (t < a.getBoxes().length) {
                                if (a.next(new Vector3f(step, 0.0f, 0.0f), t).intersects2(this.articles[i].getBoxes()[k])) {
                                    a.getPhysics().collideX(this, step, a, this.articles[i]);
                                    return;
                                }
                                t = (short)(t + 1);
                            }
                            k = (short)(k + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
                step = (float)((double)step + 0.01);
            }
        }
    }

    private void collideY(Article a, int id) {
        block13: {
            block12: {
                if (!(a.dMove.y < 0.0f)) break block12;
                float step = -0.01f;
                while (step >= a.dMove.y) {
                    int i = 0;
                    while (i < this.articles.length) {
                        if (this.articles[i].getDistance(a.position) < 50.0f && i != id) {
                            int k = 0;
                            while (k < this.articles[i].getBoxes().length) {
                                short t = 0;
                                while (t < a.getBoxes().length) {
                                    if (a.next(new Vector3f(0.0f, step, 0.0f), t).intersects2(this.articles[i].getBoxes()[k])) {
                                        a.getPhysics().collideY(this, step, a, this.articles[i]);
                                        return;
                                    }
                                    t = (short)(t + 1);
                                }
                                k = (short)(k + 1);
                            }
                        }
                        i = (short)(i + 1);
                    }
                    step = (float)((double)step - 0.01);
                }
                break block13;
            }
            if (!(a.dMove.y > 0.0f)) break block13;
            float step = 0.01f;
            while (step <= a.dMove.y) {
                int i = 0;
                while (i < this.articles.length) {
                    if (this.articles[i].getDistance(a.position) < 50.0f && i != id) {
                        int k = 0;
                        while (k < this.articles[i].getBoxes().length) {
                            short t = 0;
                            while (t < a.getBoxes().length) {
                                if (a.next(new Vector3f(0.0f, step, 0.0f), t).intersects2(this.articles[i].getBoxes()[k])) {
                                    a.getPhysics().collideY(this, step, a, this.articles[i]);
                                    return;
                                }
                                t = (short)(t + 1);
                            }
                            k = (short)(k + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
                step = (float)((double)step + 0.01);
            }
        }
    }

    private void collideZ(Article a, int id) {
        block13: {
            block12: {
                if (!(a.dMove.z < 0.0f)) break block12;
                float step = -0.01f;
                while (step >= a.dMove.z) {
                    int i = 0;
                    while (i < this.articles.length) {
                        if (this.articles[i].getDistance(a.position) < 20.0f && i != id) {
                            int k = 0;
                            while (k < this.articles[i].getBoxes().length) {
                                short t = 0;
                                while (t < a.getBoxes().length) {
                                    if (a.next(new Vector3f(0.0f, 0.0f, step), t).intersects2(this.articles[i].getBoxes()[k])) {
                                        a.getPhysics().collideZ(this, step, a, this.articles[i]);
                                        return;
                                    }
                                    t = (short)(t + 1);
                                }
                                k = (short)(k + 1);
                            }
                        }
                        i = (short)(i + 1);
                    }
                    step = (float)((double)step - 0.01);
                }
                break block13;
            }
            if (!(a.dMove.z > 0.0f)) break block13;
            float step = 0.01f;
            while (step <= a.dMove.z) {
                int i = 0;
                while (i < this.articles.length) {
                    if (this.articles[i].getDistance(a.position) < 20.0f && i != id) {
                        int k = 0;
                        while (k < this.articles[i].getBoxes().length) {
                            short t = 0;
                            while (t < a.getBoxes().length) {
                                if (a.next(new Vector3f(0.0f, 0.0f, step), t).intersects2(this.articles[i].getBoxes()[k])) {
                                    a.getPhysics().collideZ(this, step, a, this.articles[i]);
                                    return;
                                }
                                t = (short)(t + 1);
                            }
                            k = (short)(k + 1);
                        }
                    }
                    i = (short)(i + 1);
                }
                step = (float)((double)step + 0.01);
            }
        }
    }

    public void collide(Article a, int id) {
        int kd = 0;
        Vector3f stepPass = a.dMove;
        if (a.dMove.z > 0.0f) {
            float step = 0.01f;
            while (step <= a.dMove.z) {
                int i = 0;
                while (i < this.articles.length) {
                    if (this.articles[i].getDistance(a.position) < 20.0f && i != id) {
                        int k = 0;
                        while (k < this.articles[i].getBoxes().length) {
                            short t = 0;
                            while (t < a.getBoxes().length) {
                                if (a.next(new Vector3f(step, step, step), t).intersects2(this.articles[i].getBoxes()[k])) {
                                    kd = i;
                                }
                                t = (short)(t + 1);
                            }
                            k = (short)(k + 1);
                        }
                    }
                    ++i;
                }
                step = (float)((double)step + 0.01);
            }
        }
        a.getPhysics().collide(this, stepPass, a, this.articles[kd]);
    }
}

