/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha2;

import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.MotionState;
import com.bulletphysics.linearmath.Transform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.FloatBuffer;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Article {
    private int bufferId;
    private FloatBuffer data;
    private boolean cullFaces = true;
    private Texture texture;
    private String name;
    public Vector3f position;
    private short numOfPlanes;
    private boolean dynamicBoundingBoxes;
    private Quat4f angle = new Quat4f();
    private RigidBody body;

    public Article(String model, Vector3f p) {
        this.position = p;
        this.loadArticle(model);
    }

    private void loadArticle(String f) {
        float mass = 0.01f;
        try {
            this.bufferId = GL15.glGenBuffers();
            BufferedReader bR = new BufferedReader(new FileReader(new File(f)));
            bR.readLine().equals("#DanModelFormat");
            this.name = bR.readLine();
            String line = bR.readLine();
            if (!line.equals("null")) {
                this.loadTexture(line);
            }
            this.numOfPlanes = (short)Integer.parseInt(bR.readLine());
            this.data = BufferUtils.createFloatBuffer(this.numOfPlanes * 24);
            float[] points = new float[this.numOfPlanes * 24];
            this.dynamicBoundingBoxes = bR.readLine().toLowerCase().equals("t");
            this.cullFaces = bR.readLine().toLowerCase().equals("t");
            mass = Float.parseFloat(bR.readLine());
            line = bR.readLine();
            Vector3f normal = new Vector3f();
            int i = 0;
            while (i < this.numOfPlanes * 3) {
                line = bR.readLine();
                points[i * 8 + 0] = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                points[i * 8 + 1] = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                points[i * 8 + 2] = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                line = bR.readLine();
                points[i * 8 + 6] = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                points[i * 8 + 7] = Float.parseFloat(line.substring(line.indexOf("\\") + 2));
                if (i % 3 == 2) {
                    Vector3f[] p = new Vector3f[]{new Vector3f(points[(i - 2) * 8 + 0], points[(i - 2) * 8 + 1], points[(i - 2) * 8 + 2]), new Vector3f(points[(i - 1) * 8 + 0], points[(i - 1) * 8 + 1], points[(i - 1) * 8 + 2]), new Vector3f(points[i * 8 + 0], points[i * 8 + 1], points[i * 8 + 2])};
                    normal = this.calculateNormal(p);
                    points[(i - 2) * 8 + 3] = normal.x;
                    points[(i - 2) * 8 + 4] = normal.y;
                    points[(i - 2) * 8 + 5] = normal.z;
                    points[(i - 1) * 8 + 3] = normal.x;
                    points[(i - 1) * 8 + 4] = normal.y;
                    points[(i - 1) * 8 + 5] = normal.z;
                    points[i * 8 + 3] = normal.x;
                    points[i * 8 + 4] = normal.y;
                    points[i * 8 + 5] = normal.z;
                }
                ++i;
            }
            this.data.put(points);
            this.data.flip();
            GL15.glBindBuffer(34962, this.bufferId);
            GL15.glBufferData(34962, this.data, 35044);
            if (bR.readLine().equals("BoundingBoxes:") && !this.dynamicBoundingBoxes) {
                line = bR.readLine();
                Vector3f top = new Vector3f();
                top.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                top.y = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                top.z = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                line = bR.readLine();
                Vector3f bottom = new Vector3f();
                bottom.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                bottom.y = Float.parseFloat(line.substring(line.indexOf("\\") + 2, line.indexOf("\\", line.indexOf("\\") + 2)));
                bottom.z = Float.parseFloat(line.substring(line.indexOf("\\", line.indexOf("\\", line.indexOf("\\") + 2)) + 2));
                line = bR.readLine();
                BoxShape collisionShape = new BoxShape(new Vector3f((top.x - bottom.x) / 2.0f, (top.y - bottom.y) / 2.0f, (top.z - bottom.z) / 2.0f));
                DefaultMotionState motionState = new DefaultMotionState();
                ((MotionState)motionState).setWorldTransform(new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 0.5f), this.position, 1.0f)));
                Vector3f inertia = new Vector3f();
                collisionShape.calculateLocalInertia(0.0f, inertia);
                this.setBody(new RigidBody(mass, motionState, collisionShape, inertia));
                this.body.setFriction(1.0f);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void move() {
        GL11.glTranslatef(this.position.x, this.position.y, this.position.z);
        GL11.glRotatef(this.angle.w, this.angle.x, this.angle.y, this.angle.z);
    }

    public void tick() {
    }

    private void loadTexture(String f) {
        try {
            this.texture = TextureLoader.getTexture("png", new FileInputStream(new File(f)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                this.texture = TextureLoader.getTexture("png", new FileInputStream(new File(f)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.texture = null;
    }

    private Vector3f calculateNormal(Vector3f[] points) {
        Vector3f u = new Vector3f(points[1].x - points[0].x, points[1].y - points[0].y, points[1].z - points[0].z);
        Vector3f v = new Vector3f(points[2].x - points[0].x, points[2].y - points[0].y, points[2].z - points[0].z);
        return new Vector3f(u.z * v.y - u.y * v.z, u.x * v.z - u.z * v.x, u.y * v.x - u.x * v.y);
    }

    public float getDistance(Vector3f o) {
        float distance = 0.0f;
        distance += (o.x - this.position.x) * (o.x - this.position.x);
        distance += (o.y - this.position.y) * (o.y - this.position.y);
        distance += (o.z - this.position.z) * (o.z - this.position.z);
        distance = (float)Math.sqrt(distance);
        return distance;
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public boolean getCullFaces() {
        return this.cullFaces;
    }

    public short getNumOfPlanes() {
        return this.numOfPlanes;
    }

    public String toString() {
        return this.name;
    }

    public Quat4f getAngle() {
        return this.angle;
    }

    public void setAngle(Quat4f angle) {
        this.angle = angle;
    }

    public RigidBody getBody() {
        return this.body;
    }

    public void setBody(RigidBody body) {
        this.body = body;
    }
}

