/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha2;

import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.SphereShape;
import com.bulletphysics.collision.shapes.StaticPlaneShape;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.RigidBodyConstructionInfo;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.linearmath.DefaultMotionState;
import com.bulletphysics.linearmath.Transform;
import java.util.HashSet;
import java.util.Set;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;
import utility.EulerCamera;

public class JBulletCode {
    private static final String WINDOW_TITLE = "JBullet Demo";
    private static final int[] WINDOW_DIMENSIONS = new int[]{640, 480};
    private static final Transform DEFAULT_BALL_TRANSFORM = new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 35.0f, 0.0f), 1.0f));
    private static EulerCamera camera = new EulerCamera.Builder().setFieldOfView(300.0f).setNearClippingPane(0.3f).setFarClippingPane(500.0f).setPosition(0.0f, 25.0f, 15.0f).build();
    private static DynamicsWorld dynamicsWorld;
    private static Set<RigidBody> balls;
    private static RigidBody controlBall;
    private static boolean applyForce;
    private static boolean createNewShape;
    private static boolean resetControlBall;
    private static Sphere sphere;

    static {
        balls = new HashSet<RigidBody>();
        applyForce = false;
        createNewShape = false;
        resetControlBall = false;
        sphere = new Sphere();
    }

    private static void setUpPhysics() {
        DbvtBroadphase broadphase = new DbvtBroadphase();
        DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
        CollisionDispatcher dispatcher = new CollisionDispatcher(collisionConfiguration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        dynamicsWorld = new DiscreteDynamicsWorld(dispatcher, broadphase, solver, collisionConfiguration);
        dynamicsWorld.setGravity(new Vector3f(0.0f, -10.0f, 0.0f));
        StaticPlaneShape groundShape = new StaticPlaneShape(new Vector3f(0.0f, 1.0f, 0.0f), 0.25f);
        SphereShape ballShape = new SphereShape(3.0f);
        DefaultMotionState groundMotionState = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), 1.0f)));
        RigidBodyConstructionInfo groundBodyConstructionInfo = new RigidBodyConstructionInfo(0.0f, groundMotionState, groundShape, new Vector3f(0.0f, 0.0f, 0.0f));
        groundBodyConstructionInfo.restitution = 0.25f;
        RigidBody groundRigidBody = new RigidBody(groundBodyConstructionInfo);
        dynamicsWorld.addRigidBody(groundRigidBody);
        DefaultMotionState ballMotionState = new DefaultMotionState(DEFAULT_BALL_TRANSFORM);
        Vector3f ballInertia = new Vector3f(0.0f, 0.0f, 0.0f);
        ((CollisionShape)ballShape).calculateLocalInertia(2.5f, ballInertia);
        RigidBodyConstructionInfo ballConstructionInfo = new RigidBodyConstructionInfo(2.5f, ballMotionState, ballShape, ballInertia);
        ballConstructionInfo.restitution = 0.5f;
        ballConstructionInfo.angularDamping = 0.95f;
        controlBall = new RigidBody(ballConstructionInfo);
        controlBall.setActivationState(4);
        balls.add(controlBall);
        dynamicsWorld.addRigidBody(controlBall);
    }

    private static void render() {
        GL11.glClear(16640);
        for (RigidBody body : balls) {
            GL11.glPushMatrix();
            Vector3f ballPosition = body.getWorldTransform((Transform)new Transform()).origin;
            GL11.glTranslatef(ballPosition.x, ballPosition.y, ballPosition.z);
            sphere.setDrawStyle(100013);
            if (body.equals(controlBall)) {
                GL11.glColor4f(0.0f, 1.0f, 0.0f, 1.0f);
            } else {
                GL11.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            }
            sphere.draw(3.0f, 30, 30);
            GL11.glPopMatrix();
        }
        GL11.glBegin(7);
        GL11.glColor4f(0.6f, 0.6f, 0.6f, 1.0f);
        GL11.glVertex3f(-50.0f, 0.0f, -50.0f);
        GL11.glColor4f(0.85f, 0.85f, 0.85f, 1.0f);
        GL11.glVertex3f(-50.0f, 0.0f, 50.0f);
        GL11.glColor4f(0.75f, 0.75f, 0.75f, 1.0f);
        GL11.glVertex3f(50.0f, 0.0f, 50.0f);
        GL11.glColor4f(0.5f, 0.5f, 0.5f, 1.0f);
        GL11.glVertex3f(50.0f, 0.0f, -50.0f);
        GL11.glEnd();
    }

    private static void logic() {
        GL11.glLoadIdentity();
        camera.applyTranslations();
        dynamicsWorld.stepSimulation(0.016666668f);
        HashSet<RigidBody> ballsToBeRemoved = new HashSet<RigidBody>();
        for (RigidBody body : balls) {
            Vector3f position = body.getMotionState().getWorldTransform((Transform)new Transform()).origin;
            if (body.equals(controlBall) || !(position.x < -50.0f || position.x > 50.0f || position.z < -50.0f) && !(position.z > 50.0f)) continue;
            ballsToBeRemoved.add(body);
        }
        for (RigidBody body : ballsToBeRemoved) {
            balls.remove(body);
            dynamicsWorld.removeRigidBody(body);
        }
        if (applyForce) {
            Transform controlBallTransform = new Transform();
            controlBall.getMotionState().getWorldTransform(controlBallTransform);
            Vector3f controlBallLocation = controlBallTransform.origin;
            Vector3f cameraPosition = new Vector3f(camera.x(), camera.y(), camera.z());
            Vector3f force = new Vector3f();
            force.sub(cameraPosition, controlBallLocation);
            controlBall.activate(true);
            controlBall.applyCentralForce(force);
        }
        if (createNewShape) {
            SphereShape shape = new SphereShape(3.0f);
            DefaultMotionState motionState = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(camera.x(), 35.0f, camera.z()), 1.0f)));
            Vector3f inertia = new Vector3f();
            ((CollisionShape)shape).calculateLocalInertia(1.0f, inertia);
            RigidBodyConstructionInfo constructionInfo = new RigidBodyConstructionInfo(1.0f, motionState, shape, inertia);
            constructionInfo.restitution = 0.75f;
            RigidBody body = new RigidBody(constructionInfo);
            dynamicsWorld.addRigidBody(body);
            balls.add(body);
            createNewShape = false;
        }
        if (resetControlBall) {
            controlBall.setCenterOfMassTransform(DEFAULT_BALL_TRANSFORM);
            controlBall.setAngularVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
            controlBall.setLinearVelocity(new Vector3f(0.0f, 0.0f, 0.0f));
            resetControlBall = false;
        }
    }

    private static void input() {
        if (Mouse.isGrabbed()) {
            camera.processMouse(1.0f);
        }
        camera.processKeyboard(16.666666f, 4.0f);
        if (Mouse.isButtonDown(0) && !Mouse.isGrabbed()) {
            Mouse.setGrabbed(true);
        } else if (Mouse.isButtonDown(1) && Mouse.isGrabbed()) {
            Mouse.setGrabbed(false);
        } else {
            applyForce = Mouse.isButtonDown(0) && Mouse.isGrabbed();
        }
        while (Keyboard.next()) {
            if (!Keyboard.getEventKeyState()) continue;
            switch (Keyboard.getEventKey()) {
                case 34: {
                    createNewShape = true;
                    break;
                }
                case 33: {
                    resetControlBall = true;
                }
            }
        }
    }

    private static void cleanUp(boolean asCrash) {
        Display.destroy();
        System.exit(asCrash ? 1 : 0);
    }

    private static void setUpMatrices() {
        camera.setAspectRatio((float)Display.getWidth() / (float)Display.getHeight());
        camera.setFieldOfView(65.0f);
        camera.applyPerspectiveMatrix();
    }

    private static void setUpStates() {
        camera.applyOptimalStates();
        GL11.glEnable(2929);
        GL11.glEnable(2884);
        GL11.glLineWidth(2.0f);
    }

    private static void update() {
        Display.update();
        Display.sync(60);
    }

    private static void enterGameLoop() {
        while (!Display.isCloseRequested()) {
            JBulletCode.render();
            JBulletCode.logic();
            JBulletCode.input();
            JBulletCode.update();
        }
    }

    private static void setUpDisplay() {
        try {
            Display.setVSyncEnabled(true);
            Display.setDisplayMode(new DisplayMode(WINDOW_DIMENSIONS[0], WINDOW_DIMENSIONS[1]));
            Display.setTitle(WINDOW_TITLE);
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            JBulletCode.cleanUp(true);
        }
    }

    public static void main(String[] args) {
        JBulletCode.setUpDisplay();
        JBulletCode.setUpStates();
        JBulletCode.setUpMatrices();
        JBulletCode.setUpPhysics();
        JBulletCode.enterGameLoop();
        JBulletCode.cleanUp(false);
    }

    private static class PhysicsSphere {
        private final Vector4f colour;
        private final float radius;
        private final int slices;
        private final int stacks;
        private final RigidBody physicsBody;
        private final DynamicsWorld physicsWorld;
        private Sphere renderSphere;

        PhysicsSphere(Vector4f colour, Vector3f position, DynamicsWorld physicsWorld, float mass, float radius, int slices, int stacks) {
            this.colour = colour;
            this.radius = radius;
            this.slices = slices;
            this.stacks = stacks;
            DefaultMotionState motion = new DefaultMotionState(new Transform(new Matrix4f(new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), position, 1.0f)));
            SphereShape shape = new SphereShape(radius);
            this.physicsBody = new RigidBody(mass, motion, shape);
            this.physicsWorld = physicsWorld;
            this.physicsWorld.addRigidBody(this.physicsBody);
            this.renderSphere = new Sphere();
        }

        void destroy() {
            this.physicsWorld.removeRigidBody(this.physicsBody);
        }

        DynamicsWorld getPhysicsWorld() {
            return this.physicsWorld;
        }

        RigidBody getPhysicsBody() {
            return this.physicsBody;
        }

        Vector3f getPosition() {
            return this.physicsBody.getCenterOfMassPosition(new Vector3f());
        }

        void draw() {
            GL11.glPushMatrix();
            Vector3f position = this.getPosition();
            GL11.glTranslatef(position.x, position.y, position.z);
            GL11.glColor4f(this.colour.x, this.colour.y, this.colour.z, this.colour.w);
            this.renderSphere.draw(this.radius, this.slices, this.stacks);
            GL11.glPopMatrix();
        }

        Vector4f getColour() {
            return new Vector4f(this.colour);
        }

        float getRadius() {
            return this.radius;
        }
    }
}

