/*
 * Decompiled with CFR 0.152.
 */
package com.Alpha2;

import com.Alpha2.Article;
import com.bulletphysics.collision.broadphase.DbvtBroadphase;
import com.bulletphysics.collision.dispatch.CollisionDispatcher;
import com.bulletphysics.collision.dispatch.DefaultCollisionConfiguration;
import com.bulletphysics.dynamics.DiscreteDynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.linearmath.Transform;
import java.awt.Point;
import javax.vecmath.Vector3f;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;

public class Module {
    private Article[] articles;
    private boolean[] keys = new boolean[11];
    public float walkingAcceleration = 0.06f;
    private final float defaultWalkingAcceleration = 0.06f;
    public float frictionAcceleration = 0.03f;
    private final float defaultFrictionAcceleration = 0.03f;
    public float maxWalkingSpeed = 0.3f;
    private final float defaultMaxWalkingSpeed = 0.6f;
    public float gravityAcceleration = -0.05f;
    private final float defaultGravityAcceleration = -0.05f;
    public boolean falling = false;
    private short cameraArticleId;
    private DynamicsWorld world;
    boolean explode = false;
    Point mp = new Point();

    public static void main(String[] args) {
        new Module();
    }

    public Module() {
        try {
            Display.setDisplayMode(new DisplayMode(1000, 500));
            Display.setVSyncEnabled(true);
            Display.setResizable(false);
            Display.setTitle("Roget Moon");
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            Display.destroy();
            System.exit(0);
        }
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(70.0f, Display.getWidth() / Display.getHeight(), 0.001f, 150.0f);
        GL11.glPopAttrib();
        GL11.glMatrixMode(5888);
        GL11.glEnable(2929);
        GL11.glEnable(3553);
        GL11.glFrontFace(2304);
        GL11.glEnable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3152, 4354);
        this.setupPhysics();
        this.articles = new Article[16];
        this.articles[0] = new Article("res\\models\\box.dmf", new Vector3f(-2.0f, 10.0f, 0.0f));
        this.articles[1] = new Article("res\\models\\box.dmf", new Vector3f(4.0f, -1.0f, -3.0f));
        this.articles[2] = new Article("res\\models\\box.dmf", new Vector3f(2.0f, 0.0f, 0.0f));
        this.articles[3] = new Article("res\\models\\box.dmf", new Vector3f(9.0f, 1.0f, 4.0f));
        this.articles[4] = new Article("res\\models\\box.dmf", new Vector3f(7.0f, 2.0f, 0.0f));
        this.articles[5] = new Article("res\\models\\box.dmf", new Vector3f(-5.0f, 3.0f, 3.0f));
        this.articles[6] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 4.0f, 2.0f));
        this.articles[7] = new Article("res\\models\\grass.dmf", new Vector3f(0.0f, -2.5f, 0.0f));
        this.articles[8] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 7.0f, 2.0f));
        this.articles[9] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 6.0f, 2.0f));
        this.articles[10] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 5.0f, 0.0f));
        this.articles[11] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 4.0f, 0.0f));
        this.articles[12] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 3.0f, 0.0f));
        this.articles[13] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 2.0f, 0.0f));
        this.articles[14] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 1.0f, 0.0f));
        this.articles[15] = new Article("res\\models\\box.dmf", new Vector3f(0.0f, 0.0f, 0.0f));
        int i = 0;
        while (i < this.articles.length) {
            this.world.addRigidBody(this.articles[i].getBody());
            ++i;
        }
        Mouse.setGrabbed(true);
        this.loop();
        i = 0;
        while (i < this.articles.length) {
            GL15.glDeleteBuffers(this.articles[i].getBufferId());
            ++i;
        }
        Display.destroy();
    }

    public void setupPhysics() {
        DefaultCollisionConfiguration collisionConfiguration = new DefaultCollisionConfiguration();
        DbvtBroadphase broadphaseInterface = new DbvtBroadphase();
        CollisionDispatcher dispatcher = new CollisionDispatcher(collisionConfiguration);
        SequentialImpulseConstraintSolver solver = new SequentialImpulseConstraintSolver();
        this.world = new DiscreteDynamicsWorld(dispatcher, broadphaseInterface, solver, collisionConfiguration);
        this.world.setGravity(new Vector3f(-1.0f, -5.0f, 0.0f));
    }

    private void loop() {
        while (!Display.isCloseRequested()) {
            GL11.glClear(16640);
            GL11.glLoadIdentity();
            this.moveCamera();
            this.render();
            this.logInput();
            this.world.stepSimulation(0.016666668f);
        }
    }

    private void render() {
        int i = 0;
        while (i < this.articles.length) {
            GL11.glPushMatrix();
            if (this.articles[i].getCullFaces()) {
                GL11.glEnable(2884);
            } else {
                GL11.glDisable(2884);
            }
            this.articles[i].move();
            if (this.articles[i].getTexture() != null) {
                this.articles[i].getTexture().bind();
            }
            GL15.glBindBuffer(34962, this.articles[i].getBufferId());
            GL11.glVertexPointer(3, 5126, 32, 0L);
            GL11.glNormalPointer(5126, 32, 12L);
            GL11.glTexCoordPointer(2, 5126, 32, 24L);
            GL11.glEnableClientState(32884);
            GL11.glEnableClientState(32885);
            GL11.glEnableClientState(32888);
            GL11.glDrawArrays(4, 0, this.articles[i].getNumOfPlanes() * 3);
            GL11.glDisableClientState(32888);
            GL11.glDisableClientState(32885);
            GL11.glDisableClientState(32884);
            GL11.glPopMatrix();
            ++i;
        }
        Display.update();
        Display.sync(90);
    }

    private void logInput() {
        this.keys[0] = Keyboard.isKeyDown(17);
        this.keys[1] = Keyboard.isKeyDown(30);
        this.keys[2] = Keyboard.isKeyDown(31);
        this.keys[3] = Keyboard.isKeyDown(32);
        this.keys[4] = Keyboard.isKeyDown(57);
        this.keys[5] = Keyboard.isKeyDown(15);
        this.keys[6] = Keyboard.isKeyDown(42);
        this.keys[7] = Keyboard.isKeyDown(29);
        this.keys[8] = Keyboard.isKeyDown(56);
        this.keys[9] = Keyboard.isKeyDown(16);
        this.keys[10] = Keyboard.isKeyDown(18);
        if (Keyboard.isKeyDown(1)) {
            Display.destroy();
            System.exit(0);
        }
        Vector3f dMove = new Vector3f();
        if (this.keys[0]) {
            dMove.z = 2.0f;
        }
        if (this.keys[2]) {
            dMove.z = -2.0f;
        }
        if (this.keys[1]) {
            dMove.x = 2.0f;
        }
        if (this.keys[3]) {
            dMove.x = -2.0f;
        }
        this.articles[this.cameraArticleId].getBody().applyCentralImpulse(dMove);
        this.mp.x += Mouse.getDX() / 8;
        this.mp.y -= Mouse.getDY() / 8;
        this.articles[this.cameraArticleId].getBody().applyTorque(new Vector3f(0.0f, this.mp.x, 0.0f));
        if (this.mp.y >= 85) {
            this.mp.y = 85;
        }
        if (this.mp.y <= -70) {
            this.mp.y = -70;
        }
        if (this.mp.x >= 360) {
            this.mp.x -= 360;
        }
        if (this.mp.x <= -360) {
            this.mp.x += 360;
        }
        if (this.keys[5]) {
            this.cameraArticleId = this.cameraArticleId == 15 ? (short)0 : (short)(this.cameraArticleId + 1);
        }
    }

    public void moveCamera() {
        int i = 0;
        while (i < this.articles.length) {
            this.articles[i].position = this.articles[i].getBody().getMotionState().getWorldTransform((Transform)new Transform()).origin;
            ++i;
        }
        GL11.glRotatef(30.0f, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef((float)(270 - this.mp.x) + 0.0f, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(-this.articles[this.cameraArticleId].getPosition().x - (float)(Math.cos(Math.toRadians(this.mp.x)) * 4.0), -this.articles[this.cameraArticleId].getPosition().y - 2.0f, -this.articles[this.cameraArticleId].getPosition().z + (float)(Math.sin(Math.toRadians(this.mp.x)) * 4.0));
    }
}

