/*
 * Decompiled with CFR 0.152.
 */
package com.LD33;

import com.LD33.Article;
import com.LD33.Box;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Dolphin
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static JFrame frame;
    private static final Dimension FRAME_DIM;
    private static BufferedImage buffer;
    private static Graphics g3;
    private static byte refresh;
    private static final byte refreshRate = 30;
    private static byte moveCount;
    private static final byte moveRate = 30;
    private static short bubbleCount;
    private static final short bubbleRate = 500;
    private static short boatCount;
    private static final short boatRate = 30;
    private static byte boatNum;
    private static ArrayList<Article> articles;
    private static Point velocity;
    private static byte splashCount;
    private static Article splash;
    private static short chargeCount;
    private static short score;
    private static byte health;
    private static byte explosion;
    private static byte scene;
    private static byte cursor;
    private static boolean boundingBoxes;
    private static short titleSequence;
    private static final String[] menuItems;
    private static boolean[] keys;
    private static boolean facingLeft;

    static {
        FRAME_DIM = new Dimension(1000, 500);
        refresh = 0;
        moveCount = 0;
        bubbleCount = 0;
        boatCount = 0;
        boatNum = 0;
        velocity = new Point(0, 0);
        splashCount = 0;
        chargeCount = 0;
        score = 0;
        health = (byte)100;
        explosion = 0;
        scene = 0;
        cursor = 0;
        boundingBoxes = false;
        titleSequence = (short)600;
        menuItems = new String[]{"START", "HELP", "EXIT"};
        keys = new boolean[5];
        facingLeft = false;
    }

    public static void main(String[] args) {
        frame = new JFrame("Dolphin Meat");
        frame.setDefaultCloseOperation(3);
        frame.setSize(FRAME_DIM);
        frame.setResizable(false);
        final Dolphin dolphin = new Dolphin();
        frame.add(dolphin);
        frame.addKeyListener(dolphin);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        articles = new ArrayList();
        articles.add(new Article(new Point(300, 100), new Box(new Point(65, 97), new Dimension(138, 28)), "res\\LD33\\images\\dolphin.png", 0));
        int x = -10;
        while (x < 10) {
            Article water = new Article(new Point(x * 256, 0), new Box(new Point(0, 0), new Dimension(0, 0)), "res\\LD33\\images\\water.png", 1);
            articles.add(water);
            int i = 0;
            while (i < 8) {
                Article wave = new Article(new Point(x * 256 + i * 32, -8), new Box(new Point(0, 0), new Dimension(32, 16)), "res\\LD33\\images\\wave.gif", 5);
                articles.add(wave);
                i = (byte)(i + 1);
            }
            x = (short)(x + 1);
        }
        x = 0;
        while (x < 6) {
            Article coral = new Article(new Point(new Random().nextInt() % 1000 + 900, 744), new Box(new Point(12, 35), new Dimension(35, 221)), "res\\LD33\\images\\coral0.png", 7);
            articles.add(coral);
            x = (byte)(x + 1);
        }
        x = 0;
        while (x < 10) {
            int y = -5;
            while (y < 20) {
                Article oceanFloor0 = new Article(new Point(x * 64 - 1200, y * 64), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor0);
                Article oceanFloor1 = new Article(new Point(x * 64 + 2000, y * 64), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor1);
                Article oceanFloor2 = new Article(new Point(x * 64 - 1600, y * 64 - 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor2);
                Article oceanFloor3 = new Article(new Point(x * 64 + 2400, y * 64 - 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor3);
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        x = -20;
        while (x < 50) {
            Article oceanFloor0 = new Article(new Point(x * 64, 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor1 = new Article(new Point(x * 64, 1064), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor2 = new Article(new Point(x * 64, 1128), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor3 = new Article(new Point(x * 64, 1192), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            articles.add(oceanFloor0);
            articles.add(oceanFloor1);
            articles.add(oceanFloor2);
            articles.add(oceanFloor3);
            x = (short)(x + 1);
        }
        articles.add(new Article(new Point(2300, 1000), new Box(new Point(0, 0), new Dimension(0, 0)), "res\\LD33\\images\\confirmation.png", 15));
        splash = new Article(new Point(0, 2000), new Box(new Point(0, 0), new Dimension(128, 128)), "res\\LD33\\images\\splash.png", 7);
        articles.add(splash);
        buffer = new BufferedImage(Dolphin.FRAME_DIM.width, Dolphin.FRAME_DIM.height, 2);
        g3 = buffer.getGraphics();
        Thread t = new Thread(dolphin);
        t.start();
        Thread song = new Thread(new Runnable(){

            @Override
            public void run() {
                dolphin.loopSound("theme.wav");
            }
        });
        song.start();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(buffer, 0, 0, null);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                Dolphin.keys[0] = true;
                if (cursor != 0 && scene == 0) {
                    cursor = (byte)(cursor - 1);
                    break;
                }
                if (scene != 0) break;
                cursor = (byte)2;
                break;
            }
            case 40: {
                Dolphin.keys[1] = true;
                if (cursor != 2 && scene == 0) {
                    cursor = (byte)(cursor + 1);
                    break;
                }
                if (scene != 0) break;
                cursor = 0;
                break;
            }
            case 37: {
                Dolphin.keys[2] = true;
                break;
            }
            case 39: {
                Dolphin.keys[3] = true;
                break;
            }
            case 32: {
                Dolphin.keys[4] = true;
                break;
            }
            case 10: {
                if (scene == 0) {
                    if (cursor == 0) {
                        scene = 1;
                    }
                    if (cursor == 1) {
                        scene = (byte)2;
                    }
                    if (cursor != 2) break;
                    System.exit(0);
                    break;
                }
                if (scene == 1) {
                    if (health > 0) break;
                    Dolphin.reset();
                    break;
                }
                if (scene != 2) break;
                scene = 0;
                break;
            }
            case 69: {
                boundingBoxes = !boundingBoxes;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                Dolphin.keys[0] = false;
                break;
            }
            case 40: {
                Dolphin.keys[1] = false;
                break;
            }
            case 37: {
                Dolphin.keys[2] = false;
                break;
            }
            case 39: {
                Dolphin.keys[3] = false;
                break;
            }
            case 32: {
                Dolphin.keys[4] = false;
                if (chargeCount >= 10) break;
                Dolphin.velocity.x *= 4 / (chargeCount + 1);
                Dolphin.velocity.y *= 4 / (chargeCount + 1);
                chargeCount = (short)200;
                this.playSound("swim.wav");
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void playSound(String f) {
        try {
            URL url = new URL("file", "localhost", "res\\LD33\\audio\\" + f);
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    private void loopSound(String f) {
        try {
            URL url = new URL("file", "localhost", "res\\LD33\\audio\\" + f);
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.loop(100);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    private void explode(short id) {
        if (Dolphin.articles.get((int)id).pos.x - Dolphin.articles.get((int)0).pos.x < 200) {
            health = (byte)(health - 10);
            articles.get(id).setImage("res\\LD33\\images\\explosion.png");
            Dolphin.articles.get((int)id).id = (byte)13;
            Dolphin.articles.get((int)id).pos.x -= 10;
            Dolphin.articles.get((int)id).pos.y -= 10;
            explosion = (byte)20;
            this.playSound("explosion.wav");
        }
    }

    private void make() {
        if (scene == 0) {
            g3.setFont(new Font("Impact", 1, 20));
            g3.drawImage(new ImageIcon("res\\LD33\\images\\title.png").getImage(), 0, 0, null);
            int i = 0;
            while (i < menuItems.length) {
                if (i == cursor) {
                    g3.setColor(Color.RED);
                    g3.drawRect(690, i * 40 + 125, 200, 30);
                }
                g3.setColor(Color.WHITE);
                g3.drawString(menuItems[i], 700, i * 40 + 150);
                i = (byte)(i + 1);
            }
        } else if (scene == 1) {
            g3.setColor(Color.BLUE);
            g3.fillRect(0, 0, Dolphin.FRAME_DIM.width, Dolphin.FRAME_DIM.height);
            int i = 1;
            while (i < articles.size()) {
                g3.drawImage(Dolphin.articles.get((int)i).image, explosion + Dolphin.articles.get((int)i).pos.x - Dolphin.articles.get((int)0).pos.x + Dolphin.FRAME_DIM.width / 2 - 135, explosion + Dolphin.articles.get((int)i).pos.y - Dolphin.articles.get((int)0).pos.y + Dolphin.FRAME_DIM.height / 2 - 35, null);
                g3.setColor(Color.RED);
                if (boundingBoxes) {
                    g3.drawRect(explosion + Dolphin.articles.get((int)i).pos.x + Dolphin.articles.get((int)i).box.pos.x - Dolphin.articles.get((int)0).pos.x + Dolphin.FRAME_DIM.width / 2 - 135, explosion + Dolphin.articles.get((int)i).pos.y + Dolphin.articles.get((int)i).box.pos.y - Dolphin.articles.get((int)0).pos.y + Dolphin.FRAME_DIM.height / 2 - 35, Dolphin.articles.get((int)i).box.dim.width, Dolphin.articles.get((int)i).box.dim.height);
                }
                i = (short)(i + 1);
            }
            if (splashCount > 0) {
                if (splashCount == 1) {
                    Dolphin.splash.pos = new Point(0, 2000);
                }
                splashCount = (byte)(splashCount - 1);
            }
            if (explosion > 0) {
                explosion = (byte)(explosion - 1);
            }
            g3.drawImage(Dolphin.articles.get((int)0).image, Dolphin.FRAME_DIM.width / 2 - 135, Dolphin.FRAME_DIM.height / 2 - 35, null);
            if (boundingBoxes) {
                g3.drawRect(Dolphin.articles.get((int)0).box.pos.x + Dolphin.FRAME_DIM.width / 2 - 135, Dolphin.articles.get((int)0).box.pos.y + Dolphin.FRAME_DIM.height / 2 - 35, Dolphin.articles.get((int)0).box.dim.width, Dolphin.articles.get((int)0).box.dim.height);
            }
            g3.setColor(Color.BLACK);
            g3.drawString("Sailors: " + score, 52, 52);
            g3.setColor(Color.RED);
            g3.drawString("Sailors: " + score, 50, 50);
            g3.setColor(Color.BLACK);
            g3.fillRect(700, 50, 200, 30);
            g3.setColor(Color.RED);
            g3.fillRect(700, 50, health * 2, 30);
            g3.setColor(Color.WHITE);
            g3.drawString("HEALTH", 720, 70);
            if (health <= 0) {
                g3.setColor(Color.BLACK);
                g3.drawString("You ARE DOLPHIN MEAT", Dolphin.FRAME_DIM.width / 2 - 98, 102);
                g3.drawString("PRESS <ENTER> TO GO TO THE MENU", Dolphin.FRAME_DIM.width / 2 - 148, 152);
                g3.setColor(Color.WHITE);
                g3.drawString("You ARE DOLPHIN MEAT", Dolphin.FRAME_DIM.width / 2 - 100, 100);
                g3.drawString("PRESS <ENTER> TO GO TO THE MENU", Dolphin.FRAME_DIM.width / 2 - 150, 150);
            }
            if (titleSequence > 0) {
                if (titleSequence > 400) {
                    g3.setColor(Color.BLACK);
                    g3.drawString("WHAT A CUTE DOLPHIN", Dolphin.FRAME_DIM.width / 2 - 98, 422);
                    g3.setColor(Color.WHITE);
                    g3.drawString("WHAT A CUTE DOLPHIN", Dolphin.FRAME_DIM.width / 2 - 100, 420);
                } else if (titleSequence > 200) {
                    g3.setColor(Color.BLACK);
                    g3.drawString("LET'S HAVE SAILOR FOR DINNER", Dolphin.FRAME_DIM.width / 2 - 118, 422);
                    g3.setColor(Color.WHITE);
                    g3.drawString("LET'S HAVE SAILOR FOR DINNER", Dolphin.FRAME_DIM.width / 2 - 120, 420);
                } else {
                    g3.setColor(Color.BLACK);
                    g3.drawString("REMEMBER TO WATCH OUT FOR BOMBS", Dolphin.FRAME_DIM.width / 2 - 128, 422);
                    g3.setColor(Color.WHITE);
                    g3.drawString("REMEMBER TO WATCH OUT FOR BOMBS", Dolphin.FRAME_DIM.width / 2 - 130, 420);
                }
                titleSequence = (short)(titleSequence - 1);
            }
        } else if (scene == 2) {
            g3.drawImage(new ImageIcon("res\\LD33\\images\\help.png").getImage(), 0, 0, null);
        }
        this.repaint();
    }

    private void tick() {
        if (health > 0 && scene == 1) {
            if (boatCount > 30 && boatNum < 4 && Dolphin.articles.get((int)0).pos.y >= -50) {
                int x = 0;
                Random r = new Random();
                while (Math.abs((x = 600 + r.nextInt() % 1180) - Dolphin.articles.get((int)0).pos.x) < 600) {
                }
                boolean left = r.nextInt() % 2 == 0;
                Article boat = new Article(new Point(x, -200), new Box(new Point(33, 162), new Dimension(187, 62)), "res\\LD33\\images\\boat" + (left ? 1 : 0) + ".png", 8);
                boat.left = left;
                articles.add(boat);
                boatNum = (byte)(boatNum + 1);
                boatCount = 0;
            }
            boatCount = (short)(boatCount + 1);
            if (Math.abs(Dolphin.velocity.y) < 15) {
                if (keys[0]) {
                    Dolphin.velocity.y -= 2;
                } else if (keys[1]) {
                    Dolphin.velocity.y += 2;
                }
            }
            if (Dolphin.articles.get((int)0).pos.y + Dolphin.articles.get((int)0).box.pos.y < -20) {
                Dolphin.velocity.y += 3;
            } else if (Dolphin.velocity.y > 0) {
                --Dolphin.velocity.y;
            } else if (Dolphin.velocity.y < 0) {
                ++Dolphin.velocity.y;
            }
            if (Math.abs(Dolphin.velocity.x) < 15) {
                if (keys[2]) {
                    Dolphin.velocity.x -= 2;
                } else if (keys[3]) {
                    Dolphin.velocity.x += 2;
                }
            }
            if (Dolphin.velocity.x > 0) {
                --Dolphin.velocity.x;
            } else if (Dolphin.velocity.x < 0) {
                ++Dolphin.velocity.x;
            }
            this.animateDolphin();
            if (chargeCount > 1) {
                chargeCount = (short)(chargeCount - 5);
            }
            int i = 0;
            while (i < articles.size()) {
                if (Dolphin.articles.get((int)i).id == 4) {
                    Dolphin.articles.get((int)i).pos.y -= 15;
                    if (Dolphin.articles.get((int)i).pos.y < 0) {
                        articles.remove(i);
                    }
                } else if (Dolphin.articles.get((int)i).id == 9) {
                    Dolphin.articles.get((int)i).pos.y += 4;
                    if (Dolphin.articles.get((int)i).pos.y > 800) {
                        Dolphin.articles.get((int)i).id = (byte)10;
                    }
                } else if (Dolphin.articles.get((int)i).id == 11) {
                    Dolphin.articles.get((int)i).pos.y += 2;
                } else if (Dolphin.articles.get((int)i).id == 12) {
                    Dolphin.articles.get((int)i).pos.y += 2;
                } else if (Dolphin.articles.get((int)i).id == 13 && explosion == 0) {
                    articles.remove(i);
                }
                ++i;
            }
            this.collideX();
            Dolphin.articles.get((int)0).pos.x += Dolphin.velocity.x;
            this.collideY();
            Dolphin.articles.get((int)0).pos.y += Dolphin.velocity.y;
        }
    }

    private void collideX() {
        Box b = new Box(new Point(Dolphin.articles.get((int)0).box.pos.x + Dolphin.articles.get((int)0).pos.x + Dolphin.velocity.x, Dolphin.articles.get((int)0).box.pos.y + Dolphin.articles.get((int)0).pos.y), Dolphin.articles.get((int)0).box.dim);
        short i = 1;
        while (i < articles.size()) {
            Box c = new Box(new Point(Dolphin.articles.get((int)i).box.pos.x + Dolphin.articles.get((int)i).pos.x, Dolphin.articles.get((int)i).box.pos.y + Dolphin.articles.get((int)i).pos.y), Dolphin.articles.get((int)i).box.dim);
            if (b.intersects(c)) {
                if (Dolphin.articles.get((int)i).id == 6) {
                    Dolphin.velocity.x = 0;
                }
                if (Dolphin.articles.get((int)i).id == 8) {
                    if (Math.abs(Dolphin.velocity.x) > 20) {
                        this.wreckBoat(i);
                    } else {
                        Dolphin.velocity.x = 0;
                    }
                }
                if (Dolphin.articles.get((int)i).id == 11 && Dolphin.articles.get((int)i).pos.y > 50) {
                    score = (short)(score + 1);
                    articles.remove(i);
                    this.playSound("eat.wav");
                }
                if (Dolphin.articles.get((int)i).id == 12 && Dolphin.articles.get((int)i).pos.y > 50 && explosion == 0) {
                    this.explode(i);
                }
            }
            i = (short)(i + 1);
        }
    }

    private void collideY() {
        Box b = new Box(new Point(Dolphin.articles.get((int)0).box.pos.x + Dolphin.articles.get((int)0).pos.x, Dolphin.articles.get((int)0).box.pos.y + Dolphin.articles.get((int)0).pos.y + Dolphin.velocity.y), Dolphin.articles.get((int)0).box.dim);
        short i = 1;
        while (i < articles.size()) {
            Box c = new Box(new Point(Dolphin.articles.get((int)i).box.pos.x + Dolphin.articles.get((int)i).pos.x, Dolphin.articles.get((int)i).box.pos.y + Dolphin.articles.get((int)i).pos.y), Dolphin.articles.get((int)i).box.dim);
            if (b.intersects(c)) {
                if (Dolphin.articles.get((int)i).id == 5) {
                    if (Dolphin.velocity.y > 2 && splashCount == 0) {
                        Dolphin.splash.pos = new Point(Dolphin.articles.get((int)0).pos.x + 64, Dolphin.articles.get((int)0).pos.y + 54);
                        splashCount = (byte)10;
                        this.playSound("splash.wav");
                    }
                } else if (Dolphin.articles.get((int)i).id == 2) {
                    Dolphin.velocity.y = 0;
                }
                if (Dolphin.articles.get((int)i).id == 6) {
                    Dolphin.velocity.y = 0;
                }
                if (Dolphin.articles.get((int)i).id == 8) {
                    if (Math.abs(Dolphin.velocity.y) > 25) {
                        this.wreckBoat(i);
                    } else {
                        Dolphin.velocity.y = 0;
                    }
                }
                if (Dolphin.articles.get((int)i).id == 11 && Dolphin.articles.get((int)i).pos.y > 50) {
                    score = (short)(score + 1);
                    articles.remove(i);
                    this.playSound("eat.wav");
                }
                if (Dolphin.articles.get((int)i).id == 12 && Dolphin.articles.get((int)i).pos.y > 50 && explosion == 0) {
                    this.explode(i);
                }
            }
            i = (short)(i + 1);
        }
    }

    private void wreckBoat(short id) {
        articles.get(id).setImage("res\\LD33\\images\\wreck" + (Dolphin.articles.get((int)id).left ? 1 : 0) + ".png");
        Dolphin.articles.get((int)id).id = (byte)9;
        boatNum = (byte)(boatNum - 1);
        Random r = new Random();
        int k = 0;
        while (k < Math.abs(r.nextInt() % 4) + 1) {
            Article trash = null;
            trash = r.nextInt() % 4 == 0 ? new Article(new Point(Dolphin.articles.get((int)id).pos.x + r.nextInt() % 200 + 100, r.nextInt() % 20), new Box(new Point(10, 10), new Dimension(10, 10)), "res\\LD33\\images\\bomb.png", 12) : new Article(new Point(Dolphin.articles.get((int)id).pos.x + r.nextInt() % 100, r.nextInt() % 20), new Box(new Point(3, 10), new Dimension(25, 17)), "res\\LD33\\images\\sailor" + (r.nextInt() % 2 == 0 ? 1 : 0) + ".png", 11);
            articles.add(trash);
            k = (byte)(k + 1);
        }
        this.playSound("wreck.wav");
        this.playSound("scream.wav");
    }

    private void animateDolphin() {
        int imageId = 0;
        Box box = null;
        boolean change = true;
        if (keys[0]) {
            Box b = new Box(new Point(113 + Dolphin.articles.get((int)0).pos.x, 51 + Dolphin.articles.get((int)0).pos.y), new Dimension(39, 132));
            int i = 1;
            while (i < articles.size()) {
                Box c = new Box(new Point(Dolphin.articles.get((int)i).box.pos.x + Dolphin.articles.get((int)i).pos.x, Dolphin.articles.get((int)i).box.pos.y + Dolphin.articles.get((int)i).pos.y), Dolphin.articles.get((int)i).box.dim);
                if (b.intersects(c) && (Dolphin.articles.get((int)i).id == 2 || Dolphin.articles.get((int)i).id == 6 || Dolphin.articles.get((int)i).id == 8)) {
                    change = false;
                }
                i = (short)(i + 1);
            }
            box = new Box(new Point(113, 51), new Dimension(39, 132));
            imageId = 2;
        } else if (keys[1]) {
            Box b = new Box(new Point(113 + Dolphin.articles.get((int)0).pos.x, 70 + Dolphin.articles.get((int)0).pos.y), new Dimension(43, 130));
            int i = 1;
            while (i < articles.size()) {
                Box c = new Box(new Point(Dolphin.articles.get((int)i).box.pos.x + Dolphin.articles.get((int)i).pos.x, Dolphin.articles.get((int)i).box.pos.y + Dolphin.articles.get((int)i).pos.y), Dolphin.articles.get((int)i).box.dim);
                if (b.intersects(c) && (Dolphin.articles.get((int)i).id == 2 || Dolphin.articles.get((int)i).id == 6 || Dolphin.articles.get((int)i).id == 8)) {
                    change = false;
                }
                i = (short)(i + 1);
            }
            box = new Box(new Point(113, 70), new Dimension(43, 130));
            imageId = 4;
        } else {
            Box b = new Box(new Point(65 + Dolphin.articles.get((int)0).pos.x, 97 + Dolphin.articles.get((int)0).pos.y), new Dimension(138, 28));
            int i = 1;
            while (i < articles.size()) {
                Box c = new Box(new Point(Dolphin.articles.get((int)i).box.pos.x + Dolphin.articles.get((int)i).pos.x, Dolphin.articles.get((int)i).box.pos.y + Dolphin.articles.get((int)i).pos.y), Dolphin.articles.get((int)i).box.dim);
                if (b.intersects(c) && (Dolphin.articles.get((int)i).id == 2 || Dolphin.articles.get((int)i).id == 6 || Dolphin.articles.get((int)i).id == 8)) {
                    change = false;
                }
                i = (short)(i + 1);
            }
            imageId = 0;
            box = new Box(new Point(65, 97), new Dimension(138, 28));
        }
        if (keys[2]) {
            facingLeft = true;
        } else if (keys[3]) {
            facingLeft = false;
        }
        if (facingLeft) {
            imageId = (byte)(imageId + 1);
        }
        if (change) {
            articles.get(0).setImage("res\\LD33\\images\\dolphin" + imageId + ".png");
            Dolphin.articles.get((int)0).box = box;
        }
    }

    @Override
    public void run() {
        while (true) {
            if (refresh > 30) {
                this.make();
                refresh = 0;
            }
            refresh = (byte)(refresh + 1);
            if (moveCount > 30) {
                this.tick();
                moveCount = 0;
            }
            moveCount = (byte)(moveCount + 1);
            if (bubbleCount > 500) {
                Random r = new Random();
                Article bubble = new Article(new Point(500 + r.nextInt() % 1000, 1100), new Box(new Point(0, 0), new Dimension(32, 32)), "res\\LD33\\images\\bubble" + Math.abs(r.nextInt() % 3) + ".png", 4);
                articles.add(bubble);
                bubbleCount = 0;
            }
            bubbleCount = (short)(bubbleCount + 1);
            try {
                Thread.sleep(1L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static void reset() {
        health = (byte)100;
        score = 0;
        scene = 0;
        boatNum = 0;
        titleSequence = (short)600;
        articles = new ArrayList();
        articles.add(new Article(new Point(300, 100), new Box(new Point(65, 97), new Dimension(138, 28)), "res\\LD33\\images\\dolphin.png", 0));
        int x = -10;
        while (x < 10) {
            Article water = new Article(new Point(x * 256, 0), new Box(new Point(0, 0), new Dimension(0, 0)), "res\\LD33\\images\\water.png", 1);
            articles.add(water);
            int i = 0;
            while (i < 8) {
                Article wave = new Article(new Point(x * 256 + i * 32, -8), new Box(new Point(0, 0), new Dimension(32, 16)), "res\\LD33\\images\\wave.gif", 5);
                articles.add(wave);
                i = (byte)(i + 1);
            }
            x = (short)(x + 1);
        }
        x = 0;
        while (x < 6) {
            Article coral = new Article(new Point(new Random().nextInt() % 1000 + 900, 744), new Box(new Point(12, 35), new Dimension(35, 221)), "res\\LD33\\images\\coral0.png", 7);
            articles.add(coral);
            x = (byte)(x + 1);
        }
        x = 0;
        while (x < 10) {
            int y = -5;
            while (y < 20) {
                Article oceanFloor0 = new Article(new Point(x * 64 - 1200, y * 64), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor0);
                Article oceanFloor1 = new Article(new Point(x * 64 + 2000, y * 64), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor1);
                Article oceanFloor2 = new Article(new Point(x * 64 - 1600, y * 64 - 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor2);
                Article oceanFloor3 = new Article(new Point(x * 64 + 2400, y * 64 - 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\rockFace.png", 6);
                articles.add(oceanFloor3);
                y = (short)(y + 1);
            }
            x = (short)(x + 1);
        }
        x = -20;
        while (x < 50) {
            Article oceanFloor0 = new Article(new Point(x * 64, 1000), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor1 = new Article(new Point(x * 64, 1064), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor2 = new Article(new Point(x * 64, 1128), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            Article oceanFloor3 = new Article(new Point(x * 64, 1192), new Box(new Point(0, 0), new Dimension(64, 64)), "res\\LD33\\images\\oceanFloor.png", 2);
            articles.add(oceanFloor0);
            articles.add(oceanFloor1);
            articles.add(oceanFloor2);
            articles.add(oceanFloor3);
            x = (short)(x + 1);
        }
        splash = new Article(new Point(0, 2000), new Box(new Point(0, 0), new Dimension(128, 128)), "res\\LD33\\images\\splash.png", 7);
        articles.add(splash);
    }
}

