/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Plane;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Article {
    public Vector3f pos;
    public Vector3f angle;
    public Vector3f scale;
    public int bufferId;
    private FloatBuffer data;
    public Texture texture;
    public Plane[] planes;
    public String name;
    public boolean cull = false;
    public boolean mipMapped = false;

    public Article(String filePath, Vector3f p, Vector3f a, Vector3f s) {
        this.parseFile(filePath);
        this.pos = p;
        this.angle = a;
        this.scale = s;
        int i = 0;
        while (i < this.planes.length) {
            Plane plane = this.planes[i];
            int k = 0;
            while (k < plane.points.length) {
                plane.points[k].x *= this.scale.x;
                plane.points[k].y *= this.scale.y;
                plane.points[k].z *= this.scale.z;
                ++k;
            }
            ++i;
        }
        this.setupVBO();
    }

    public Article(Vector3f p, Vector3f a, Vector3f s) {
        this.pos = p;
        this.angle = a;
        this.scale = s;
    }

    private void parseFile(String filePath) {
        ArrayList<Plane> planeArrayList = new ArrayList<Plane>();
        try {
            BufferedReader bR = new BufferedReader(new FileReader(new File(filePath)));
            String line = bR.readLine();
            int lineId = 0;
            ArrayList<Vector3f> f0 = null;
            ArrayList<Vector3f> f1 = null;
            boolean a = true;
            while (line != null) {
                if (lineId != 0 || line.equals("#DanModelFormat")) {
                    if (lineId == 1) {
                        this.name = line;
                    } else if (lineId == 2) {
                        this.texture = this.getTexture(line);
                    } else if (lineId == 3) {
                        this.cull = line.equals("true");
                    } else if (lineId > 4) {
                        if (line.equals("EndPlane")) {
                            Plane plane = new Plane(f0, f1);
                            plane.boundingBox = a;
                            planeArrayList.add(plane);
                        } else if (line.length() > 5) {
                            Vector v;
                            if (line.substring(0, 5).equals("plane")) {
                                a = Boolean.parseBoolean(bR.readLine());
                                f0 = new ArrayList<Vector3f>();
                                f1 = new ArrayList<Vector3f>();
                                lineId = (short)(lineId + 1);
                            } else if (line.indexOf("\\", line.indexOf("\\") + 1) != -1) {
                                v = new Vector3f();
                                v.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                                line = line.substring(line.indexOf("\\") + 1);
                                v.y = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                                line = line.substring(line.indexOf("\\") + 1);
                                v.z = Float.parseFloat(line);
                                f0.add((Vector3f)v);
                            } else {
                                v = new Vector2f();
                                ((Vector2f)v).x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                                line = line.substring(line.indexOf("\\") + 1);
                                ((Vector2f)v).y = Float.parseFloat(line);
                                f1.add((Vector3f)v);
                            }
                        }
                    }
                    lineId = (short)(lineId + 1);
                    line = bR.readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.planes = new Plane[planeArrayList.size()];
        int i = 0;
        while (i < this.planes.length) {
            this.planes[i] = (Plane)planeArrayList.get(i);
            ++i;
        }
    }

    protected void setupVBO() {
        this.bufferId = GL15.glGenBuffers();
        this.data = BufferUtils.createFloatBuffer(this.planes.length * 24);
        float[] points = new float[this.planes.length * 24];
        int i = 0;
        while (i < this.planes.length) {
            Plane p = this.planes[i];
            points[i * 24 + 0] = p.points[0].x;
            points[i * 24 + 1] = p.points[0].y;
            points[i * 24 + 2] = p.points[0].z;
            points[i * 24 + 3] = p.normal.x;
            points[i * 24 + 4] = p.normal.y;
            points[i * 24 + 5] = p.normal.z;
            points[i * 24 + 6] = p.textureCoords[0].x;
            points[i * 24 + 7] = p.textureCoords[0].y;
            points[i * 24 + 8] = p.points[1].x;
            points[i * 24 + 9] = p.points[1].y;
            points[i * 24 + 10] = p.points[1].z;
            points[i * 24 + 11] = p.normal.x;
            points[i * 24 + 12] = p.normal.y;
            points[i * 24 + 13] = p.normal.z;
            points[i * 24 + 14] = p.textureCoords[1].x;
            points[i * 24 + 15] = p.textureCoords[1].y;
            points[i * 24 + 16] = p.points[2].x;
            points[i * 24 + 17] = p.points[2].y;
            points[i * 24 + 18] = p.points[2].z;
            points[i * 24 + 19] = p.normal.x;
            points[i * 24 + 20] = p.normal.y;
            points[i * 24 + 21] = p.normal.z;
            points[i * 24 + 22] = p.textureCoords[2].x;
            points[i * 24 + 23] = p.textureCoords[2].y;
            ++i;
        }
        this.data.put(points);
        this.data.flip();
        GL15.glBindBuffer(34962, this.bufferId);
        GL15.glBufferData(34962, this.data, 35044);
        GL15.glBindBuffer(34962, 0);
    }

    public float distance(Vector3f origin) {
        return (float)Math.sqrt((this.pos.x + origin.x) * (this.pos.x + origin.x) + (this.pos.y + origin.y) * (this.pos.y + origin.y) + (this.pos.z + origin.z) * (this.pos.z + origin.z));
    }

    public Texture getTexture(String key) {
        try {
            return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

