/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Article;
import com.PreAlpha.Plane;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class HeightMap
extends Article {
    private float cellScale = 1.0f;
    private float heightVariation = 3264.0f;

    public HeightMap(String filePath, Vector3f p, Vector3f a, Vector3f s) {
        super(p, a, s);
        this.cull = true;
        this.texture = this.getTexture("res\\images\\grass.png");
        this.parseImage(filePath);
        this.setupVBO();
    }

    public void parseImage(String filePath) {
        Image buffer = new ImageIcon(filePath).getImage();
        BufferedImage image = new BufferedImage(buffer.getWidth(null), buffer.getHeight(null), 2);
        Graphics g3 = image.getGraphics();
        g3.drawImage(buffer, 0, 0, null);
        this.planes = new Plane[(image.getWidth() - 1) * (image.getHeight() - 1) * 2];
        int y = 0;
        while (y < image.getHeight() - 1) {
            int x = 0;
            while (x < image.getWidth() - 1) {
                Color c0 = new Color(image.getRGB(x, y));
                Color c1 = new Color(image.getRGB(x + 1, y));
                Color c2 = new Color(image.getRGB(x + 1, y + 1));
                Color c3 = new Color(image.getRGB(x, y + 1));
                Vector3f[] f0 = new Vector3f[]{new Vector3f((float)x / this.cellScale, (float)(c0.getRed() + c0.getBlue() * 255 - 32640) / this.heightVariation, (float)y / this.cellScale), new Vector3f((float)(x + 1) / this.cellScale, (float)(c1.getRed() + c1.getBlue() * 255 - 32640) / this.heightVariation, (float)y / this.cellScale), new Vector3f((float)(x + 1) / this.cellScale, (float)(c2.getRed() + c2.getBlue() * 255 - 32640) / this.heightVariation, (float)(y + 1) / this.cellScale), new Vector3f((float)x / this.cellScale, (float)(c3.getRed() + c3.getBlue() * 255 - 32640) / this.heightVariation, (float)(y + 1) / this.cellScale)};
                Vector2f[] f1 = new Vector2f[]{new Vector2f(((float)x + 0.0f) / (float)image.getWidth(), ((float)y + 0.0f) / (float)image.getWidth()), new Vector2f(((float)x + 1.0f) / (float)image.getWidth(), ((float)y + 0.0f) / (float)image.getWidth()), new Vector2f(((float)x + 1.0f) / (float)image.getWidth(), ((float)y + 1.0f) / (float)image.getWidth()), new Vector2f(((float)x + 0.0f) / (float)image.getWidth(), ((float)y + 1.0f) / (float)image.getWidth())};
                Plane plane = new Plane(f0, f1);
                int k = 0;
                while (k < plane.points.length) {
                    plane.points[k].x *= this.scale.x;
                    plane.points[k].y *= this.scale.y;
                    plane.points[k].z *= this.scale.z;
                    ++k;
                }
                Plane[] planeArray = plane.triangulate();
                planeArray[0] = planeArray[0].getPlane();
                planeArray[1] = planeArray[1].getPlane();
                this.planes[y * (image.getWidth() - 1) + x] = planeArray[0];
                this.planes[y * (image.getWidth() - 1) + x + this.planes.length / 2] = planeArray[1];
                ++x;
            }
            ++y;
        }
    }
}

