/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Plane;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;
import org.lwjgl.util.vector.Vector;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Model {
    public Texture texture;
    public ArrayList<Plane> planes;
    public String name;
    public boolean cull = false;

    public Model(String filePath) {
        this.planes = new ArrayList();
        this.parseFile(filePath);
    }

    public Model() {
        this.name = "";
        this.planes = new ArrayList();
        Vector3f[] f0 = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
        Vector2f[] f2 = new Vector2f[]{new Vector2f(0.0f, 1.0f), new Vector2f(0.0f, 0.0f), new Vector2f(1.0f, 0.0f), new Vector2f(1.0f, 1.0f)};
        Plane plane = new Plane(f0, f2);
        this.planes.add(plane);
    }

    private void parseFile(String filePath) {
        try {
            BufferedReader bR = new BufferedReader(new FileReader(new File(filePath)));
            String line = bR.readLine();
            int lineId = 0;
            ArrayList<Vector3f> f0 = null;
            ArrayList<Vector3f> f1 = null;
            boolean a = true;
            while (line != null) {
                if (lineId != 0 || line.equals("#DanModelFormat")) {
                    if (lineId == 1) {
                        this.name = line;
                    } else if (lineId == 2) {
                        this.texture = this.getTexture(line);
                    } else if (lineId == 3) {
                        this.cull = line.equals("true");
                    } else if (lineId > 4) {
                        Vector v;
                        if (line.equals("EndPlane")) {
                            Plane plane = new Plane(f0, f1);
                            plane.boundingBox = a;
                            this.planes.add(plane);
                        } else if (line.substring(0, 5).equals("plane")) {
                            a = Boolean.parseBoolean(bR.readLine());
                            f0 = new ArrayList<Vector3f>();
                            f1 = new ArrayList<Vector3f>();
                            lineId = (short)(lineId + 1);
                        } else if (line.indexOf("\\", line.indexOf("\\") + 1) != -1) {
                            v = new Vector3f();
                            v.x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                            line = line.substring(line.indexOf("\\") + 1);
                            v.y = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                            line = line.substring(line.indexOf("\\") + 1);
                            v.z = Float.parseFloat(line);
                            f0.add((Vector3f)v);
                        } else {
                            v = new Vector2f();
                            ((Vector2f)v).x = Float.parseFloat(line.substring(0, line.indexOf("\\")));
                            line = line.substring(line.indexOf("\\") + 1);
                            ((Vector2f)v).y = Float.parseFloat(line);
                            f1.add((Vector3f)v);
                        }
                    }
                    lineId = (short)(lineId + 1);
                    line = bR.readLine();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Texture getTexture(String key) {
        try {
            return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

