/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Model;
import com.PreAlpha.Plane;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class ModelMaker
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = -5776076599169152532L;
    private Point mp = new Point(0, 0);
    private boolean[] keys = new boolean[21];
    private Vector3f origin = new Vector3f(0.0f, 0.0f, -1.0f);
    private float speed = 0.0f;
    private float speedRef = 0.1f;
    private Model model;
    private short selectedPlane = 0;
    private final Dimension DIM;
    private boolean navigate = false;
    private boolean wireFrame = true;
    private boolean solidFrame = true;
    private JFrame frame;
    protected JTabbedPane tabbedPane;
    private JTextField[] vertexTextFields;
    private JTextField[] normalTextField;
    private JTextField[] textureCoordTextFields;
    private JPanel planeEditorPanel;
    private final String textureFilePath = "res\\images\\lightPole.png";
    private final String modelLoadFilePath = "res\\models\\edit\\lightPole.dmf";
    private final String modelSaveFilePath = "res\\models\\edit\\lightPole.dmf";
    private final String exportFilePath = "res\\models\\lightPole.dmf";
    private byte editingId = 0;
    private byte axisId = 0;
    private boolean loopGo = true;
    private Vector3f scaleView = new Vector3f(1.0f, 1.0f, 1.0f);
    private Texture normalTexture;

    public static void main(String[] args) {
        new ModelMaker();
    }

    public ModelMaker() {
        this.DIM = Toolkit.getDefaultToolkit().getScreenSize();
        this.setupViewer();
        this.setupEditor();
        this.loop();
        Display.destroy();
        System.exit(0);
    }

    private void setupViewer() {
        try {
            Display.setDisplayMode(new DisplayMode(this.DIM.width, this.DIM.height / 2));
            Display.setLocation(0, 0);
            Display.setVSyncEnabled(true);
            Display.setResizable(false);
            Display.setTitle("Super Model Maker");
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.destroy();
        }
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(70.0f, Display.getWidth() / Display.getHeight(), 0.001f, 80.0f);
        GL11.glPopAttrib();
        GL11.glMatrixMode(5888);
        GL11.glEnable(2929);
        GL11.glEnable(3553);
        GL11.glEnable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3152, 4354);
        this.model = !"res\\models\\edit\\lightPole.dmf".equals("") ? new Model("res\\models\\edit\\lightPole.dmf") : new Model();
        if (!"res\\images\\lightPole.png".equals("")) {
            this.model.texture = this.model.getTexture("res\\images\\lightPole.png");
        }
        this.model.name = "nothing";
        this.normalTexture = this.getTexture("res\\images\\normalTexture.png");
        GL11.glFrontFace(2304);
    }

    private void setupEditor() {
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(this.DIM.width, this.DIM.height / 2 - 30);
        this.frame.setLocation(0, this.DIM.height / 2 + 30);
        this.frame.setResizable(true);
        this.frame.setUndecorated(true);
        this.frame.setAlwaysOnTop(true);
        this.frame.setFocusable(true);
        this.setupSwing();
        this.addKeyListener(this);
        this.frame.addKeyListener(this);
        this.frame.setVisible(true);
        this.requestFocus();
    }

    private void setupSwing() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new TabHandler());
        short i = 0;
        while (i < this.model.planes.size()) {
            this.planeEditorPanel = this.loadPlane(i);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this.planeEditorPanel);
            this.tabbedPane.addTab("" + (i + 1), null, scrollPane, "Points: " + this.model.planes.get((int)i).points.length);
            i = (short)(i + 1);
        }
        this.frame.add(this.tabbedPane);
        this.selectedPlane = (short)this.tabbedPane.getSelectedIndex();
        this.planeEditorPanel = this.loadPlane(this.selectedPlane);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setViewportView(this.planeEditorPanel);
        this.tabbedPane.setComponentAt(this.selectedPlane, scrollPane);
        this.frame.revalidate();
    }

    private JPanel loadPlane(short planeId) {
        Plane plane = this.model.planes.get(planeId);
        JPanel panel = new JPanel(new GridLayout(0, 6, 14, 14));
        this.vertexTextFields = new JTextField[plane.points.length * 3];
        this.normalTextField = new JTextField[3];
        this.textureCoordTextFields = new JTextField[plane.points.length * 2];
        int i = 0;
        while (i < plane.points.length) {
            this.vertexTextFields[i * 3] = new JTextField("" + plane.points[i].x);
            this.vertexTextFields[i * 3 + 1] = new JTextField("" + plane.points[i].y);
            this.vertexTextFields[i * 3 + 2] = new JTextField("" + plane.points[i].z);
            this.textureCoordTextFields[i * 2] = new JTextField("" + plane.textureCoords[i].x);
            this.textureCoordTextFields[i * 2 + 1] = new JTextField("" + plane.textureCoords[i].y);
            ++i;
        }
        this.normalTextField[0] = new JTextField("" + plane.normal.x);
        this.normalTextField[1] = new JTextField("" + plane.normal.y);
        this.normalTextField[2] = new JTextField("" + plane.normal.z);
        JButton reloadViewerButton = new JButton("Load");
        reloadViewerButton.addActionListener(this);
        panel.add(reloadViewerButton);
        JButton addTriangleButton = new JButton("Add Triangle");
        addTriangleButton.addActionListener(this);
        panel.add(addTriangleButton);
        JButton addQuadButton = new JButton("Add Quad");
        addQuadButton.addActionListener(this);
        panel.add(addQuadButton);
        JButton copyPlaneButton = new JButton("Copy Plane");
        copyPlaneButton.addActionListener(this);
        panel.add(copyPlaneButton);
        JButton deletePlaneButton = new JButton("Delete Plane");
        deletePlaneButton.addActionListener(this);
        panel.add(deletePlaneButton);
        JButton exportButton = new JButton("Save");
        exportButton.addActionListener(this);
        panel.add(exportButton);
        panel.add(new JLabel("Normal: "));
        panel.add(this.normalTextField[0]);
        panel.add(this.normalTextField[1]);
        panel.add(this.normalTextField[2]);
        JButton invertNormalButton = new JButton("Invert Normal");
        invertNormalButton.addActionListener(this);
        panel.add(invertNormalButton);
        JCheckBox cullFaceBox = new JCheckBox("Cull Faces", this.model.cull);
        cullFaceBox.addActionListener(new CheckBoxHandler());
        panel.add(cullFaceBox);
        int i2 = 0;
        while (i2 < plane.points.length) {
            panel.add(new JLabel("Point " + i2 + ":"));
            panel.add(this.vertexTextFields[i2 * 3]);
            panel.add(this.vertexTextFields[i2 * 3 + 1]);
            panel.add(this.vertexTextFields[i2 * 3 + 2]);
            panel.add(this.textureCoordTextFields[i2 * 2]);
            panel.add(this.textureCoordTextFields[i2 * 2 + 1]);
            ++i2;
        }
        return panel;
    }

    private void loop() {
        while (this.loopGo) {
            if (Display.isCloseRequested()) {
                this.loopGo = false;
            }
            GL11.glClear(16640);
            GL11.glLoadIdentity();
            this.move();
            this.render();
            this.logInput();
        }
    }

    private void render() {
        Plane plane;
        int i;
        if (this.solidFrame) {
            i = 0;
            while (i < this.model.planes.size()) {
                if (this.model.texture != null) {
                    this.model.texture.bind();
                }
                if (this.model.cull) {
                    GL11.glEnable(2884);
                } else {
                    GL11.glDisable(2884);
                }
                plane = this.model.planes.get(i);
                if (plane.points.length == 3) {
                    GL11.glBegin(4);
                    int k = 0;
                    while (k < plane.points.length) {
                        GL11.glTexCoord2f(plane.textureCoords[k].x, plane.textureCoords[k].y);
                        GL11.glVertex3f(plane.points[k].x * this.scaleView.x, plane.points[k].y * this.scaleView.y, plane.points[k].z * this.scaleView.z);
                        k = (byte)(k + 1);
                    }
                    GL11.glEnd();
                } else if (plane.points.length == 4) {
                    GL11.glBegin(7);
                    int k = 0;
                    while (k < plane.points.length) {
                        GL11.glTexCoord2f(plane.textureCoords[k].x, plane.textureCoords[k].y);
                        GL11.glVertex3f(plane.points[k].x * this.scaleView.x, plane.points[k].y * this.scaleView.y, plane.points[k].z * this.scaleView.z);
                        k = (byte)(k + 1);
                    }
                    GL11.glEnd();
                }
                GL11.glDisable(2884);
                if (i == this.selectedPlane) {
                    Vector3f average = plane.average();
                    this.normalTexture.bind();
                    GL11.glBegin(1);
                    GL11.glVertex3f((average.x + plane.normal.x) * this.scaleView.x, (average.y + plane.normal.y) * this.scaleView.y, (average.z + plane.normal.z) * this.scaleView.z);
                    GL11.glVertex3f(average.x * this.scaleView.x, average.y * this.scaleView.y, average.z * this.scaleView.z);
                    GL11.glEnd();
                    GL11.glBegin(4);
                    GL11.glVertex3f((average.x + plane.normal.x) * this.scaleView.x, (average.y + plane.normal.y - 0.05f) * this.scaleView.y, (average.z + plane.normal.z - 0.1f) * this.scaleView.z);
                    GL11.glVertex3f((average.x + plane.normal.x) * this.scaleView.x, (average.y + plane.normal.y + 0.05f) * this.scaleView.y, (average.z + plane.normal.z - 0.1f) * this.scaleView.z);
                    GL11.glVertex3f((average.x + plane.normal.x) * this.scaleView.x, (average.y + plane.normal.y) * this.scaleView.y, (average.z + plane.normal.z + 0.1f) * this.scaleView.z);
                    GL11.glEnd();
                    GL11.glBegin(4);
                    GL11.glVertex3f((average.x + plane.normal.x - 0.05f) * this.scaleView.x, (average.y + plane.normal.y) * this.scaleView.y, (average.z + plane.normal.z - 0.1f) * this.scaleView.z);
                    GL11.glVertex3f((average.x + plane.normal.x + 0.05f) * this.scaleView.x, (average.y + plane.normal.y) * this.scaleView.y, (average.z + plane.normal.z - 0.1f) * this.scaleView.z);
                    GL11.glVertex3f((average.x + plane.normal.x) * this.scaleView.x, (average.y + plane.normal.y) * this.scaleView.y, (average.z + plane.normal.z + 0.1f) * this.scaleView.z);
                    GL11.glEnd();
                }
                ++i;
            }
        }
        if (this.wireFrame) {
            i = 0;
            while (i < this.model.planes.size()) {
                plane = this.model.planes.get(i);
                int k = 0;
                while (k < plane.points.length) {
                    this.normalTexture.bind();
                    GL11.glBegin(1);
                    GL11.glVertex3f(plane.points[k].x * this.scaleView.x, plane.points[k].y * this.scaleView.y, plane.points[k].z * this.scaleView.z);
                    if (k == plane.points.length - 1) {
                        GL11.glVertex3f(plane.points[0].x * this.scaleView.x, plane.points[0].y * this.scaleView.y, plane.points[0].z * this.scaleView.z);
                    } else {
                        GL11.glVertex3f(plane.points[k + 1].x * this.scaleView.x, plane.points[k + 1].y * this.scaleView.y, plane.points[k + 1].z * this.scaleView.z);
                    }
                    GL11.glEnd();
                    k = (byte)(k + 1);
                }
                ++i;
            }
        }
        Display.update();
        Display.sync(90);
    }

    private void logInput() {
        int dWheel;
        int i;
        Plane plane;
        this.keys[0] = Keyboard.isKeyDown(17);
        this.keys[1] = Keyboard.isKeyDown(30);
        this.keys[2] = Keyboard.isKeyDown(31);
        this.keys[3] = Keyboard.isKeyDown(32);
        this.keys[4] = Keyboard.isKeyDown(57);
        this.keys[5] = Keyboard.isKeyDown(15);
        this.keys[6] = Keyboard.isKeyDown(42);
        this.keys[7] = Keyboard.isKeyDown(29);
        this.keys[8] = Keyboard.isKeyDown(56);
        this.keys[9] = Keyboard.isKeyDown(16);
        this.keys[10] = Keyboard.isKeyDown(18);
        this.keys[11] = Keyboard.isKeyDown(146);
        this.keys[12] = Keyboard.isKeyDown(20);
        this.keys[13] = Mouse.isButtonDown(2);
        this.keys[14] = Keyboard.isKeyDown(200);
        this.keys[15] = Keyboard.isKeyDown(208);
        this.keys[16] = Keyboard.isKeyDown(203);
        this.keys[17] = Keyboard.isKeyDown(205);
        Vector2f mouseD = new Vector2f(Mouse.getDX(), Mouse.getDY());
        if (this.keys[13] || this.keys[9]) {
            if (!this.navigate) {
                Mouse.setGrabbed(true);
                this.navigate = true;
            }
        } else if (this.navigate) {
            Mouse.setGrabbed(false);
            this.navigate = false;
        }
        if (Keyboard.isKeyDown(25)) {
            this.exportModel();
        }
        if (Keyboard.isKeyDown(45)) {
            this.axisId = 0;
        } else if (Keyboard.isKeyDown(21)) {
            this.axisId = 1;
        } else if (Keyboard.isKeyDown(44)) {
            this.axisId = (byte)2;
        }
        if (Keyboard.isKeyDown(46)) {
            this.editingId = 0;
        } else if (Keyboard.isKeyDown(20)) {
            this.editingId = 1;
        } else if (Keyboard.isKeyDown(37)) {
            this.editingId = (byte)2;
        }
        boolean planeEdited = false;
        if (this.editingId == 0) {
            plane = this.model.planes.get(this.selectedPlane);
            i = 0;
            while (i < plane.points.length) {
                if (this.keys[14]) {
                    if (this.axisId == 0) {
                        plane.points[i].x = (float)((double)plane.points[i].x + 0.1);
                        planeEdited = true;
                    } else if (this.axisId == 1) {
                        plane.points[i].y = (float)((double)plane.points[i].y + 0.1);
                        planeEdited = true;
                    } else if (this.axisId == 2) {
                        plane.points[i].z = (float)((double)plane.points[i].z + 0.1);
                        planeEdited = true;
                    }
                }
                if (this.keys[15]) {
                    if (this.axisId == 0) {
                        plane.points[i].x = (float)((double)plane.points[i].x - 0.1);
                        planeEdited = true;
                    } else if (this.axisId == 1) {
                        plane.points[i].y = (float)((double)plane.points[i].y - 0.1);
                        planeEdited = true;
                    } else if (this.axisId == 2) {
                        plane.points[i].z = (float)((double)plane.points[i].z - 0.1);
                        planeEdited = true;
                    }
                }
                ++i;
            }
        } else if (this.editingId == 1) {
            plane = this.model.planes.get(this.selectedPlane);
            i = 0;
            while (i < plane.points.length) {
                if (this.keys[14]) {
                    plane.textureCoords[i].y += this.speedRef / 2.0f;
                    planeEdited = true;
                }
                if (this.keys[15]) {
                    plane.textureCoords[i].y -= this.speedRef / 2.0f;
                    planeEdited = true;
                }
                if (this.keys[16]) {
                    plane.textureCoords[i].x -= this.speedRef / 2.0f;
                    planeEdited = true;
                }
                if (this.keys[17]) {
                    plane.textureCoords[i].x += this.speedRef / 2.0f;
                    planeEdited = true;
                }
                ++i;
            }
        } else if (this.editingId == 2) {
            plane = this.model.planes.get(this.selectedPlane);
            i = 0;
            while (i < plane.points.length) {
                if (this.keys[14]) {
                    plane.textureCoords[i].x *= 1.0f + this.speedRef / 2.0f;
                    plane.textureCoords[i].y *= 1.0f + this.speedRef / 2.0f;
                    planeEdited = true;
                }
                if (this.keys[15]) {
                    plane.textureCoords[i].x *= 1.0f - this.speedRef / 2.0f;
                    plane.textureCoords[i].y *= 1.0f - this.speedRef / 2.0f;
                    planeEdited = true;
                }
                ++i;
            }
        }
        if (Mouse.isButtonDown(0)) {
            if (this.editingId == 1) {
                plane = this.model.planes.get(this.selectedPlane);
                i = 0;
                while (i < plane.points.length) {
                    plane.textureCoords[i].x += mouseD.x / 10.0f;
                    plane.textureCoords[i].y += mouseD.y / 10.0f;
                    ++i;
                }
                planeEdited = true;
            }
            if (this.editingId == 2 && mouseD.x != 0.0f) {
                plane = this.model.planes.get(this.selectedPlane);
                i = 0;
                while (i < plane.points.length) {
                    plane.textureCoords[i].x *= 1.0f / mouseD.x;
                    plane.textureCoords[i].y *= 1.0f / mouseD.x;
                    ++i;
                }
                planeEdited = true;
            }
        }
        if (planeEdited) {
            this.selectedPlane = (short)this.tabbedPane.getSelectedIndex();
            this.planeEditorPanel = this.loadPlane(this.selectedPlane);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this.planeEditorPanel);
            this.tabbedPane.setComponentAt(this.selectedPlane, scrollPane);
            this.frame.revalidate();
        }
        if (Keyboard.isKeyDown(1)) {
            this.loopGo = false;
        }
        if ((dWheel = Mouse.getDWheel()) != 0) {
            if (dWheel > 0) {
                this.scaleView.x *= 1.1f;
                this.scaleView.y *= 1.1f;
                this.scaleView.z *= 1.1f;
            } else {
                this.scaleView.x *= 0.9f;
                this.scaleView.y *= 0.9f;
                this.scaleView.z *= 0.9f;
            }
        }
        if (this.navigate) {
            if (this.keys[4]) {
                this.origin.y -= this.speedRef;
            }
            if (this.keys[6]) {
                this.origin.y += this.speedRef;
            }
            this.mp.x = (int)((float)this.mp.x + mouseD.x / 5.0f);
            this.mp.y = (int)((float)this.mp.y - mouseD.y / 5.0f);
            if (this.mp.y >= 85) {
                this.mp.y = 85;
            }
            if (this.mp.y <= -70) {
                this.mp.y = -70;
            }
            if (this.mp.x >= 360) {
                this.mp.x -= 360;
            }
            if (this.mp.x <= -360) {
                this.mp.x += 360;
            }
            double angle = this.mp.x;
            if (!this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3]) {
                if (this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                    angle -= 45.0;
                } else if (this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                    angle += 45.0;
                } else if (!this.keys[0] && this.keys[1] && this.keys[2] && !this.keys[3]) {
                    angle -= 135.0;
                } else if (!this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                    angle -= 90.0;
                } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && this.keys[3]) {
                    angle += 135.0;
                } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && !this.keys[3]) {
                    angle += 180.0;
                } else if (!this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                    angle += 90.0;
                }
            }
            if (!(this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3])) {
                this.speed = 0.0f;
            } else {
                this.speed = this.speedRef;
                if (this.keys[8]) {
                    this.speed *= 1.5f;
                } else if (Keyboard.isKeyDown(29)) {
                    this.speed /= 1.5f;
                }
            }
            this.origin.x = (float)((double)this.origin.x - (double)this.speed * Math.sin(Math.toRadians(angle)));
            this.origin.z = (float)((double)this.origin.z + (double)this.speed * Math.cos(Math.toRadians(angle)));
        }
    }

    private void move() {
        GL11.glRotatef(this.mp.y, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.mp.x, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(this.origin.x, this.origin.y, this.origin.z);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (source.getText().equals("Load")) {
            this.syncPlanes();
        } else if (source.getText().equals("Add Triangle")) {
            this.addNewPlane((byte)3);
        } else if (source.getText().equals("Add Quad")) {
            this.addNewPlane((byte)4);
        } else if (source.getText().equals("Invert Normal")) {
            this.syncPlanes();
            this.model.planes.get(this.selectedPlane).invertNormal();
            this.selectedPlane = (short)this.tabbedPane.getSelectedIndex();
            this.planeEditorPanel = this.loadPlane(this.selectedPlane);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this.planeEditorPanel);
            this.tabbedPane.setComponentAt(this.selectedPlane, scrollPane);
            this.frame.revalidate();
        } else if (source.getText().equals("Copy Plane")) {
            this.syncPlanes();
            this.copyPlane();
        } else if (source.getText().equals("Delete Plane")) {
            this.model.planes.remove(this.selectedPlane);
            this.tabbedPane.removeTabAt(this.selectedPlane);
            if (this.selectedPlane == this.model.planes.size()) {
                this.selectedPlane = (short)(this.selectedPlane - 1);
            }
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(this.planeEditorPanel);
            this.tabbedPane.setComponentAt(this.selectedPlane, scrollPane);
            this.frame.revalidate();
        } else if (source.getText().equals("Save")) {
            this.saveModel();
        }
    }

    public void syncPlanes() {
        int i = 0;
        while (i < this.model.planes.get((int)this.selectedPlane).points.length) {
            this.model.planes.get((int)this.selectedPlane).points[i].x = Float.parseFloat(this.vertexTextFields[i * 3 + 0].getText());
            this.model.planes.get((int)this.selectedPlane).points[i].y = Float.parseFloat(this.vertexTextFields[i * 3 + 1].getText());
            this.model.planes.get((int)this.selectedPlane).points[i].z = Float.parseFloat(this.vertexTextFields[i * 3 + 2].getText());
            this.model.planes.get((int)this.selectedPlane).textureCoords[i].x = Float.parseFloat(this.textureCoordTextFields[i * 2].getText());
            this.model.planes.get((int)this.selectedPlane).textureCoords[i].y = Float.parseFloat(this.textureCoordTextFields[i * 2 + 1].getText());
            ++i;
        }
        this.model.planes.get((int)this.selectedPlane).normal = this.model.planes.get(this.selectedPlane).calculateNormal();
    }

    public void addNewPlane(byte n) {
        Vector3f[] f0;
        if (n == 3) {
            f0 = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
            Vector2f[] f1 = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.5f, 1.0f), new Vector2f(1.0f, 0.0f)};
            Plane plane = new Plane(f0, f1);
            this.model.planes.add(plane);
        } else if (n == 4) {
            f0 = new Vector3f[]{new Vector3f(-0.5f, -0.5f, 0.0f), new Vector3f(-0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, -0.5f, 0.0f)};
            Vector2f[] f1 = new Vector2f[]{new Vector2f(0.0f, 0.0f), new Vector2f(0.0f, 1.0f), new Vector2f(1.0f, 1.0f), new Vector2f(1.0f, 0.0f)};
            Plane plane = new Plane(f0, f1);
            this.model.planes.add(plane);
        }
        this.planeEditorPanel = this.loadPlane((short)(this.model.planes.size() - 1));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setViewportView(this.planeEditorPanel);
        this.tabbedPane.addTab("" + (short)this.model.planes.size(), null, scrollPane, "Points: " + this.model.planes.get((int)((short)this.model.planes.size() - 1)).points.length);
        this.frame.revalidate();
        this.selectedPlane = (short)(this.model.planes.size() - 1);
    }

    public void copyPlane() {
        Plane oldPlane = this.model.planes.get(this.selectedPlane);
        Vector3f[] f0 = new Vector3f[oldPlane.points.length];
        Vector2f[] f2 = new Vector2f[oldPlane.textureCoords.length];
        int i = 0;
        while (i < oldPlane.points.length) {
            f0[i] = new Vector3f(oldPlane.points[i].x, oldPlane.points[i].y, oldPlane.points[i].z);
            f2[i] = new Vector2f(oldPlane.textureCoords[i].x, oldPlane.textureCoords[i].y);
            ++i;
        }
        Plane plane = new Plane(f0, f2);
        plane.cull = oldPlane.cull;
        plane.boundingBox = oldPlane.boundingBox;
        this.model.planes.add(plane);
        this.planeEditorPanel = this.loadPlane((short)(this.model.planes.size() - 1));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setVerticalScrollBarPolicy(22);
        scrollPane.setViewportView(this.planeEditorPanel);
        this.tabbedPane.addTab("" + (short)this.model.planes.size(), null, scrollPane, "Points: " + this.model.planes.get((int)((short)this.model.planes.size() - 1)).points.length);
        this.selectedPlane = (short)(this.model.planes.size() - 1);
        this.tabbedPane.setSelectedIndex(this.selectedPlane);
        this.frame.revalidate();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.loopGo = false;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.loopGo = false;
        }
        if (e.getKeyCode() == 80) {
            this.exportModel();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void saveModel() {
        try {
            String fileString = "#DanModelFormat\n";
            fileString = String.valueOf(fileString) + this.model.name + "\n";
            fileString = String.valueOf(fileString) + "res\\images\\lightPole.png\n";
            fileString = String.valueOf(fileString) + this.model.cull + "\n\n";
            int i = 0;
            while (i < this.model.planes.size()) {
                Plane plane = this.model.planes.get(i).getPlane();
                fileString = String.valueOf(fileString) + "plane" + i + "\n";
                fileString = String.valueOf(fileString) + plane.boundingBox + "\n";
                int k = 0;
                while (k < plane.points.length) {
                    fileString = String.valueOf(fileString) + plane.points[k].x + "\\" + plane.points[k].y + "\\" + plane.points[k].z + "\n";
                    fileString = String.valueOf(fileString) + plane.textureCoords[k].x + "\\" + plane.textureCoords[k].y + "\n";
                    ++k;
                }
                fileString = String.valueOf(fileString) + "EndPlane";
                if (i != this.model.planes.size() - 1) {
                    fileString = String.valueOf(fileString) + "\n";
                }
                ++i;
            }
            FileWriter fw = new FileWriter(new File("res\\models\\edit\\lightPole.dmf"));
            fw.write(fileString);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void exportModel() {
        try {
            String fileString = "#DanModelFormat\n";
            fileString = String.valueOf(fileString) + this.model.name + "\n";
            fileString = String.valueOf(fileString) + "res\\images\\lightPole.png\n";
            fileString = String.valueOf(fileString) + this.model.cull + "\n\n";
            int planeCount = 0;
            int i = 0;
            while (i < this.model.planes.size()) {
                Plane plane = this.model.planes.get(i).getPlane();
                if (plane.points.length == 3) {
                    fileString = String.valueOf(fileString) + "plane" + planeCount + "\n";
                    fileString = String.valueOf(fileString) + plane.boundingBox + "\n";
                    int k = 0;
                    while (k < 3) {
                        fileString = String.valueOf(fileString) + plane.points[k].x + "\\" + plane.points[k].y + "\\" + plane.points[k].z + "\n";
                        fileString = String.valueOf(fileString) + plane.textureCoords[k].x + "\\" + plane.textureCoords[k].y + "\n";
                        ++k;
                    }
                    fileString = String.valueOf(fileString) + "EndPlane";
                    if (i != this.model.planes.size() - 1) {
                        fileString = String.valueOf(fileString) + "\n";
                    }
                    planeCount = (short)(planeCount + 1);
                } else if (plane.points.length == 4) {
                    Plane[] planeArray = plane.triangulate();
                    fileString = String.valueOf(fileString) + "plane" + planeCount + "\n";
                    fileString = String.valueOf(fileString) + planeArray[0].boundingBox + "\n";
                    int k = 0;
                    while (k < 3) {
                        fileString = String.valueOf(fileString) + planeArray[0].points[k].x + "\\" + planeArray[0].points[k].y + "\\" + planeArray[0].points[k].z + "\n";
                        fileString = String.valueOf(fileString) + planeArray[0].textureCoords[k].x + "\\" + planeArray[0].textureCoords[k].y + "\n";
                        ++k;
                    }
                    fileString = String.valueOf(fileString) + "EndPlane\n";
                    fileString = String.valueOf(fileString) + "plane" + (planeCount + 1) + "\n";
                    fileString = String.valueOf(fileString) + planeArray[1].cull + "\n";
                    fileString = String.valueOf(fileString) + planeArray[1].boundingBox + "\n";
                    k = 0;
                    while (k < 3) {
                        fileString = String.valueOf(fileString) + planeArray[1].points[k].x + "\\" + planeArray[1].points[k].y + "\\" + planeArray[1].points[k].z + "\n";
                        fileString = String.valueOf(fileString) + planeArray[1].textureCoords[k].x + "\\" + planeArray[1].textureCoords[k].y + "\n";
                        ++k;
                    }
                    fileString = String.valueOf(fileString) + "EndPlane";
                    if (i != this.model.planes.size() - 1) {
                        fileString = String.valueOf(fileString) + "\n";
                    }
                    planeCount = (short)(planeCount + 2);
                }
                ++i;
            }
            FileWriter fw = new FileWriter(new File("res\\models\\lightPole.dmf"));
            fw.write(fileString);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Texture getTexture(String key) {
        try {
            return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    class CheckBoxHandler
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            ModelMaker.this.selectedPlane = (short)ModelMaker.this.tabbedPane.getSelectedIndex();
            ((ModelMaker)ModelMaker.this).model.cull = !((ModelMaker)ModelMaker.this).model.cull;
        }
    }

    class TabHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            ModelMaker.this.selectedPlane = (short)ModelMaker.this.tabbedPane.getSelectedIndex();
            ModelMaker.this.planeEditorPanel = ModelMaker.this.loadPlane(ModelMaker.this.selectedPlane);
            JScrollPane scrollPane = new JScrollPane();
            scrollPane.setVerticalScrollBarPolicy(22);
            scrollPane.setViewportView(ModelMaker.this.planeEditorPanel);
            ModelMaker.this.tabbedPane.setComponentAt(ModelMaker.this.selectedPlane, scrollPane);
            ModelMaker.this.frame.revalidate();
        }
    }
}

