/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Article;
import com.PreAlpha.Map;
import java.awt.Point;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public class Module {
    private Map map;
    private Point mp = new Point(0, 0);
    private boolean[] keys = new boolean[14];
    private Vector3f origin = new Vector3f(0.0f, 0.0f, -1.0f);
    private float speed = 0.1f;

    public static void main(String[] args) {
        new Module();
    }

    public Module() {
        try {
            Display.setDisplayMode(Display.getDesktopDisplayMode());
            Display.setFullscreen(true);
            Display.setVSyncEnabled(true);
            Display.setResizable(false);
            Display.setTitle("Roget Moon");
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.destroy();
            System.exit(0);
        }
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(70.0f, Display.getWidth() / Display.getHeight(), 0.001f, 150.0f);
        GL11.glPopAttrib();
        GL11.glMatrixMode(5888);
        GL11.glEnable(2929);
        GL11.glEnable(3553);
        GL11.glFrontFace(2304);
        GL11.glEnable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3152, 4354);
        this.map = Map.LoadMap("res\\maps\\test.dsm");
        Mouse.setGrabbed(true);
        this.loop();
        int i = 0;
        while (i < this.map.size()) {
            GL15.glDeleteBuffers(((Article)this.map.get((int)i)).bufferId);
            ++i;
        }
        Display.destroy();
    }

    public void loop() {
        while (!Display.isCloseRequested()) {
            GL11.glClear(16640);
            GL11.glLoadIdentity();
            this.move();
            this.render();
            this.logInput();
        }
    }

    public void render() {
        int i = 0;
        while (i < this.map.size()) {
            GL11.glPushMatrix();
            Article article = (Article)this.map.get(i);
            if (article.cull) {
                GL11.glEnable(2884);
            } else {
                GL11.glDisable(2884);
            }
            GL11.glRotatef(article.angle.x, 1.0f, 0.0f, 0.0f);
            GL11.glTranslatef(article.pos.x, article.pos.y, article.pos.z);
            if (article.texture != null) {
                article.texture.bind();
            }
            GL15.glBindBuffer(34962, article.bufferId);
            GL11.glVertexPointer(3, 5126, 32, 0L);
            GL11.glNormalPointer(5126, 32, 12L);
            GL11.glTexCoordPointer(2, 5126, 32, 24L);
            GL11.glEnableClientState(32884);
            GL11.glEnableClientState(32885);
            GL11.glEnableClientState(32888);
            GL11.glDrawArrays(4, 0, article.planes.length * 3);
            GL11.glDisableClientState(32888);
            GL11.glDisableClientState(32885);
            GL11.glDisableClientState(32884);
            GL11.glPopMatrix();
            ++i;
        }
        Display.update();
    }

    private void logInput() {
        this.keys[0] = Keyboard.isKeyDown(17);
        this.keys[1] = Keyboard.isKeyDown(30);
        this.keys[2] = Keyboard.isKeyDown(31);
        this.keys[3] = Keyboard.isKeyDown(32);
        this.keys[4] = Keyboard.isKeyDown(57);
        this.keys[5] = Keyboard.isKeyDown(15);
        this.keys[6] = Keyboard.isKeyDown(42);
        this.keys[7] = Keyboard.isKeyDown(29);
        this.keys[8] = Keyboard.isKeyDown(56);
        this.keys[9] = Keyboard.isKeyDown(16);
        this.keys[10] = Keyboard.isKeyDown(18);
        if (Keyboard.isKeyDown(1)) {
            Display.destroy();
            System.exit(0);
        }
        if (this.keys[4]) {
            this.origin.y -= 0.05f;
        }
        if (this.keys[6]) {
            this.origin.y += 0.05f;
        }
        this.mp.x += Mouse.getDX() / 5;
        this.mp.y -= Mouse.getDY() / 5;
        if (this.mp.y >= 85) {
            this.mp.y = 85;
        }
        if (this.mp.y <= -70) {
            this.mp.y = -70;
        }
        if (this.mp.x >= 360) {
            this.mp.x -= 360;
        }
        if (this.mp.x <= -360) {
            this.mp.x += 360;
        }
        double angle = this.mp.x;
        if (!this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3]) {
            if (this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                angle -= 45.0;
            } else if (this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                angle += 45.0;
            } else if (!this.keys[0] && this.keys[1] && this.keys[2] && !this.keys[3]) {
                angle -= 135.0;
            } else if (!this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                angle -= 90.0;
            } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && this.keys[3]) {
                angle += 135.0;
            } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && !this.keys[3]) {
                angle += 180.0;
            } else if (!this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                angle += 90.0;
            }
        }
        if (!(this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3])) {
            this.speed = 0.0f;
        } else {
            this.speed = 0.05f;
            if (this.keys[8]) {
                this.speed *= 3.0f;
            }
        }
        this.origin.x = (float)((double)this.origin.x - (double)this.speed * Math.sin(Math.toRadians(angle)));
        this.origin.z = (float)((double)this.origin.z + (double)this.speed * Math.cos(Math.toRadians(angle)));
    }

    public void move() {
        GL11.glRotatef(this.mp.y, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.mp.x, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(this.origin.x, this.origin.y, this.origin.z);
    }
}

