/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import com.PreAlpha.Box;
import java.util.ArrayList;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

class Plane {
    public Vector3f[] points;
    public Vector3f normal;
    public Vector3f average;
    public Vector2f[] textureCoords;
    public boolean cull = false;
    public boolean boundingBox = true;
    public boolean solid = true;
    public Box box;

    public Plane(Vector3f[] pv, Vector2f[] tv) {
        this.points = pv;
        this.textureCoords = tv;
        this.normal = new Vector3f();
        this.normal = this.calculateNormal();
        this.average = this.average();
        this.box = new Box(this.points);
    }

    public Plane(ArrayList<Vector3f> pv, ArrayList<Vector2f> tv) {
        this.points = new Vector3f[pv.size()];
        this.textureCoords = new Vector2f[tv.size()];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = pv.get(i);
            this.textureCoords[i] = tv.get(i);
            ++i;
        }
        this.normal = new Vector3f();
        this.normal = this.calculateNormal();
        this.average = this.average();
        this.box = new Box(this.points);
    }

    public Vector3f calculateNormal() {
        Vector3f u = new Vector3f(this.points[1].x - this.points[0].x, this.points[1].y - this.points[0].y, this.points[1].z - this.points[0].z);
        Vector3f v = new Vector3f(this.points[2].x - this.points[0].x, this.points[2].y - this.points[0].y, this.points[2].z - this.points[0].z);
        this.normal.x = u.z * v.y - u.y * v.z;
        this.normal.y = u.x * v.z - u.z * v.x;
        this.normal.z = u.y * v.x - u.x * v.y;
        return this.normal;
    }

    public void invertNormal() {
        if (this.points.length == 3) {
            Vector3f temp = this.points[1];
            this.points[1] = this.points[0];
            this.points[0] = temp;
            Vector2f temp2 = this.textureCoords[1];
            this.textureCoords[1] = this.textureCoords[0];
            this.textureCoords[0] = temp2;
        } else if (this.points.length == 4) {
            Vector3f temp = this.points[2];
            this.points[2] = this.points[0];
            this.points[0] = temp;
            Vector2f temp2 = this.textureCoords[2];
            this.textureCoords[2] = this.textureCoords[0];
            this.textureCoords[0] = temp2;
        }
        this.normal = this.calculateNormal();
    }

    public Vector3f average() {
        Vector3f average = new Vector3f();
        int i = 0;
        while (i < this.points.length) {
            average.x += this.points[i].x;
            average.y += this.points[i].y;
            average.z += this.points[i].z;
            ++i;
        }
        average.x /= (float)this.points.length;
        average.y /= (float)this.points.length;
        average.z /= (float)this.points.length;
        return average;
    }

    public Plane getPlane() {
        this.normal = this.calculateNormal();
        this.box = new Box(this.points);
        return this;
    }

    public Plane[] triangulate() {
        if (this.points.length == 4) {
            Vector3f[] f0 = new Vector3f[]{this.points[0], this.points[1], this.points[2]};
            Vector2f[] f1 = new Vector2f[]{this.textureCoords[0], this.textureCoords[1], this.textureCoords[2]};
            Vector3f[] f2 = new Vector3f[]{this.points[2], this.points[3], this.points[0]};
            Vector2f[] f3 = new Vector2f[]{this.textureCoords[2], this.textureCoords[3], this.textureCoords[0]};
            Plane[] planes = new Plane[]{new Plane(f0, f1), new Plane(f2, f3)};
            return planes;
        }
        return null;
    }
}

