/*
 * Decompiled with CFR 0.152.
 */
package com.PreAlpha;

import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;

public class Test {
    private Point mp = new Point(0, 0);
    private boolean[] keys = new boolean[14];
    private Vector3f origin = new Vector3f(0.0f, 0.0f, -1.0f);
    private float speed = 0.1f;
    private int bufferId0;
    private int bufferId1;
    private FloatBuffer data0;
    private FloatBuffer data1;
    private Texture texture;

    public static void main(String[] args) {
        new Test();
    }

    public Test() {
        try {
            Display.setDisplayMode(new DisplayMode(800, 600));
            Display.setVSyncEnabled(true);
            Display.setResizable(false);
            Display.setTitle("Roget Moon");
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
            Display.destroy();
        }
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(70.0f, Display.getWidth() / Display.getHeight(), 0.001f, 80.0f);
        GL11.glPopAttrib();
        GL11.glMatrixMode(5888);
        GL11.glEnable(2884);
        GL11.glEnable(2929);
        GL11.glEnable(3553);
        GL11.glEnable(3008);
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glHint(3152, 4354);
        this.setup();
        this.loop();
        Display.destroy();
    }

    public void setup() {
        this.texture = Test.getTexture("res\\images\\grass.png");
        int amountOfVertices = 8;
        int vertexSize = 3;
        int textureSize = 2;
        int normalSize = 3;
        this.bufferId0 = GL15.glGenBuffers();
        this.bufferId1 = GL15.glGenBuffers();
        this.data0 = BufferUtils.createFloatBuffer(64);
        this.data1 = BufferUtils.createFloatBuffer(64);
        float[] a = new float[]{-0.5f, -0.5f, -1.0f, -0.0f, -0.0f, 1.9f, 0.0f, 0.0f, -0.5f, 0.5f, -1.0f, -0.0f, -0.0f, 1.9f, 0.0f, 1.0f, 0.5f, 0.5f, -1.0f, -0.0f, -0.0f, 1.9f, 1.0f, 1.0f, 0.5f, -0.5f, -1.0f, -0.0f, -0.0f, 1.9f, 1.0f, 0.0f, -0.5f, -0.5f, 2.0f, -0.0f, -0.0f, 10.0f, 0.0f, 0.0f, -0.5f, 0.5f, 2.0f, -0.0f, -0.0f, 10.0f, 0.0f, 1.0f, 0.5f, 0.5f, 2.0f, -0.0f, -0.0f, 10.0f, 1.0f, 1.0f, 0.5f, -0.5f, 2.0f, -0.0f, -0.0f, 10.0f, 1.0f, 0.0f};
        float[] b = new float[]{-1.0f, -0.5f, -0.5f, -0.0f, -0.0f, -0.0f, 0.0f, 0.0f, -1.0f, -0.5f, 0.5f, -0.5f, -0.0f, -0.0f, 0.0f, 1.0f, -1.0f, 0.5f, 0.5f, -0.0f, -0.0f, -0.0f, 1.0f, 1.0f, -1.0f, 0.5f, -0.5f, -0.0f, -0.0f, -0.0f, 1.0f, 0.0f, 1.0f, -0.5f, -0.5f, -1.0f, -0.0f, -0.9f, 0.0f, 0.0f, 1.0f, -0.5f, 0.5f, -1.5f, -0.0f, -0.9f, 0.0f, 1.0f, 1.0f, 0.5f, 0.5f, -1.0f, -0.0f, -0.9f, 1.0f, 1.0f, 1.0f, 0.5f, -0.5f, -1.0f, -0.0f, -0.9f, 1.0f, 0.0f};
        this.data0.put(a);
        this.data0.flip();
        this.data1.put(b);
        this.data1.flip();
        GL15.glBindBuffer(34962, this.bufferId0);
        GL15.glBufferData(34962, this.data0, 35044);
        GL15.glBindBuffer(34962, this.bufferId1);
        GL15.glBufferData(34962, this.data1, 35044);
        GL15.glBindBuffer(34962, 0);
    }

    public void loop() {
        while (!Display.isCloseRequested()) {
            GL11.glClear(16640);
            GL11.glLoadIdentity();
            this.move();
            this.render();
            this.logInput();
        }
    }

    public void render() {
        this.texture.bind();
        GL15.glBindBuffer(34962, this.bufferId0);
        GL11.glVertexPointer(3, 5126, 32, 0L);
        GL11.glNormalPointer(5126, 32, 12L);
        GL11.glTexCoordPointer(2, 5126, 32, 24L);
        GL11.glEnableClientState(32884);
        GL11.glEnableClientState(32885);
        GL11.glEnableClientState(32888);
        GL11.glDrawArrays(7, 0, 8);
        GL11.glDisableClientState(32888);
        GL11.glDisableClientState(32885);
        GL11.glDisableClientState(32884);
        GL15.glBindBuffer(34962, this.bufferId1);
        GL11.glVertexPointer(3, 5126, 32, 0L);
        GL11.glNormalPointer(5126, 32, 12L);
        GL11.glTexCoordPointer(2, 5126, 32, 24L);
        GL11.glEnableClientState(32884);
        GL11.glEnableClientState(32885);
        GL11.glEnableClientState(32888);
        GL11.glDrawArrays(7, 0, 8);
        GL11.glDisableClientState(32888);
        GL11.glDisableClientState(32885);
        GL11.glDisableClientState(32884);
        Display.update();
        Display.sync(30);
    }

    public void logInput() {
        this.keys[0] = Keyboard.isKeyDown(17);
        this.keys[1] = Keyboard.isKeyDown(30);
        this.keys[2] = Keyboard.isKeyDown(31);
        this.keys[3] = Keyboard.isKeyDown(32);
        this.keys[4] = Keyboard.isKeyDown(57);
        this.keys[5] = Keyboard.isKeyDown(15);
        this.keys[6] = Keyboard.isKeyDown(42);
        this.keys[7] = Keyboard.isKeyDown(29);
        this.keys[8] = Keyboard.isKeyDown(56);
        this.keys[9] = Keyboard.isKeyDown(16);
        this.keys[10] = Keyboard.isKeyDown(18);
        if (this.keys[9]) {
            Mouse.setGrabbed(true);
        } else if (this.keys[5]) {
            Mouse.setGrabbed(false);
        }
        if (this.keys[0]) {
            this.origin.z -= 0.1f;
        }
        if (this.keys[1]) {
            this.origin.x += 0.1f;
        }
        if (this.keys[2]) {
            this.origin.z += 0.1f;
        }
        if (this.keys[3]) {
            this.origin.x -= 0.1f;
        }
        if (Keyboard.isKeyDown(1)) {
            Display.destroy();
            System.exit(0);
        }
        this.mp.x += Mouse.getDX() / 5;
        this.mp.y -= Mouse.getDY() / 5;
        if (this.mp.y >= 85) {
            this.mp.y = 85;
        }
        if (this.mp.y <= -70) {
            this.mp.y = -70;
        }
        if (this.mp.x >= 360) {
            this.mp.x -= 360;
        }
        if (this.mp.x <= -360) {
            this.mp.x += 360;
        }
        float angle = this.mp.x;
        if (!this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3]) {
            if (this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                angle -= 45.0f;
            } else if (this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                angle += 45.0f;
            } else if (!this.keys[0] && this.keys[1] && this.keys[2] && !this.keys[3]) {
                angle -= 135.0f;
            } else if (!this.keys[0] && this.keys[1] && !this.keys[2] && !this.keys[3]) {
                angle -= 90.0f;
            } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && this.keys[3]) {
                angle += 135.0f;
            } else if (!this.keys[0] && !this.keys[1] && this.keys[2] && !this.keys[3]) {
                angle += 180.0f;
            } else if (!this.keys[0] && !this.keys[1] && !this.keys[2] && this.keys[3]) {
                angle += 90.0f;
            }
        }
        if (!(this.keys[0] || this.keys[1] || this.keys[2] || this.keys[3])) {
            this.speed = 0.0f;
        }
        this.origin.x = (float)((double)this.origin.x + (double)(-this.speed) * Math.sin(Math.toRadians(angle)));
        System.out.println((double)(-this.speed) * Math.sin(Math.toRadians(angle)));
        System.out.println(angle);
        this.origin.z = (float)((double)this.origin.z + (double)this.speed * Math.cos(Math.toRadians(angle)));
    }

    public void move() {
        GL11.glRotatef(this.mp.y, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.mp.x, 0.0f, 1.0f, 0.0f);
        GL11.glTranslatef(this.origin.x, this.origin.y, this.origin.z);
    }

    public static Texture getTexture(String key) {
        try {
            return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            try {
                return TextureLoader.getTexture("png", new FileInputStream(new File(key)));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

