/*
 * Decompiled with CFR 0.152.
 */
package com.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class Clockwork
extends JPanel
implements Runnable,
KeyListener {
    private static final long serialVersionUID = 5498641752085228484L;
    private static final Dimension DIM = new Dimension(1000, 500);
    private static JFrame frame;
    private boolean mainLoop = true;
    private static Graphics g3;
    private static BufferedImage buffer;
    private static byte refresh;
    private static final byte refreshRate = 10;
    private static boolean[] keys;
    private static char keyChar;
    private static Color ball_color;
    private static Point player_position;

    static {
        refresh = 0;
        keys = new boolean[6];
        keyChar = (char)32;
        ball_color = Color.ORANGE;
        player_position = new Point(100, 100);
    }

    public static void main(String[] args) {
        Clockwork.setup();
    }

    private static void setup() {
        frame = new JFrame("Title");
        frame.setDefaultCloseOperation(3);
        frame.setSize(DIM);
        frame.setResizable(false);
        Clockwork clockwork = new Clockwork();
        frame.add(clockwork);
        frame.addKeyListener(clockwork);
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
        buffer = new BufferedImage(Clockwork.DIM.width, Clockwork.DIM.height, 2);
        g3 = buffer.getGraphics();
        Thread t = new Thread(clockwork);
        t.start();
    }

    public Clockwork() {
        this.requestFocus();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)buffer, 0, 0, null);
    }

    private void make() {
        g3.setColor(Color.WHITE);
        g3.fillRect(0, 0, Clockwork.DIM.width, Clockwork.DIM.height);
        g3.setColor(ball_color);
        g3.fillOval(Clockwork.player_position.x, Clockwork.player_position.y, 100, 100);
        g3.setColor(Color.MAGENTA);
        int x = 0;
        while (x < keys.length) {
            if (keys[x]) {
                g3.fillRect(x * 100, 0, 100, 50);
            }
            x = (byte)(x + 1);
        }
        g3.setColor(Color.BLACK);
        g3.drawString("Key: " + keyChar, 200, 400);
        this.repaint();
    }

    @Override
    public void run() {
        while (this.mainLoop) {
            if (refresh > 10) {
                this.make();
                refresh = 0;
            }
            refresh = (byte)(refresh + 1);
            try {
                Thread.sleep(1L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        keyChar = e.getKeyChar();
        switch (e.getKeyCode()) {
            case 38: {
                Clockwork.keys[0] = true;
                --Clockwork.player_position.y;
                break;
            }
            case 40: {
                Clockwork.keys[1] = true;
                ++Clockwork.player_position.y;
                break;
            }
            case 37: {
                Clockwork.keys[2] = true;
                --Clockwork.player_position.x;
                break;
            }
            case 39: {
                Clockwork.keys[3] = true;
                ++Clockwork.player_position.x;
                break;
            }
            case 32: {
                Clockwork.keys[4] = true;
                ball_color = new Color(new Random().nextInt());
                break;
            }
            case 10: {
                Clockwork.keys[5] = true;
                Clockwork.player_position.x -= 10;
                Clockwork.player_position.y += 10;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 38: {
                Clockwork.keys[0] = false;
                break;
            }
            case 40: {
                Clockwork.keys[1] = false;
                break;
            }
            case 37: {
                Clockwork.keys[2] = false;
                break;
            }
            case 39: {
                Clockwork.keys[3] = false;
                break;
            }
            case 32: {
                Clockwork.keys[4] = false;
                break;
            }
            case 10: {
                Clockwork.keys[5] = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

