/*
 * Decompiled with CFR 0.152.
 */
package utility;

import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;
import utility.Camera;

public final class EulerCamera
implements Camera {
    private float x = 0.0f;
    private float y = 0.0f;
    private float z = 0.0f;
    private float pitch = 0.0f;
    private float yaw = 0.0f;
    private float roll = 0.0f;
    private float fov = 90.0f;
    private float aspectRatio = 1.0f;
    private final float zNear;
    private final float zFar;

    private EulerCamera(Builder builder) {
        this.x = builder.x;
        this.y = builder.y;
        this.z = builder.z;
        this.pitch = builder.pitch;
        this.yaw = builder.yaw;
        this.roll = builder.roll;
        this.aspectRatio = builder.aspectRatio;
        this.zNear = builder.zNear;
        this.zFar = builder.zFar;
        this.fov = builder.fov;
    }

    public EulerCamera() {
        this.zNear = 0.3f;
        this.zFar = 100.0f;
    }

    public EulerCamera(float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            throw new IllegalArgumentException("aspectRatio " + aspectRatio + " was 0 or was smaller than 0");
        }
        this.aspectRatio = aspectRatio;
        this.zNear = 0.3f;
        this.zFar = 100.0f;
    }

    public EulerCamera(float aspectRatio, float x, float y, float z) {
        this(aspectRatio);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public EulerCamera(float aspectRatio, float x, float y, float z, float pitch, float yaw, float roll) {
        this(aspectRatio, x, y, z);
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
    }

    public EulerCamera(float aspectRatio, float x, float y, float z, float pitch, float yaw, float roll, float zNear, float zFar) {
        if (aspectRatio <= 0.0f) {
            throw new IllegalArgumentException("aspectRatio " + aspectRatio + " was 0 or was smaller than 0");
        }
        if (zNear <= 0.0f) {
            throw new IllegalArgumentException("zNear " + zNear + " was 0 or was smaller than 0");
        }
        if (zFar <= zNear) {
            throw new IllegalArgumentException("zFar " + zFar + " was smaller or the same as zNear " + zNear);
        }
        this.aspectRatio = aspectRatio;
        this.x = x;
        this.y = y;
        this.z = z;
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
        this.zNear = zNear;
        this.zFar = zFar;
    }

    @Override
    public void processMouse() {
        float MAX_LOOK_UP = 90.0f;
        float MAX_LOOK_DOWN = -90.0f;
        float mouseDX = (float)Mouse.getDX() * 0.16f;
        float mouseDY = (float)Mouse.getDY() * 0.16f;
        this.yaw = this.yaw + mouseDX >= 360.0f ? this.yaw + mouseDX - 360.0f : (this.yaw + mouseDX < 0.0f ? 360.0f - this.yaw + mouseDX : (this.yaw += mouseDX));
        if (this.pitch - mouseDY >= -90.0f && this.pitch - mouseDY <= 90.0f) {
            this.pitch += -mouseDY;
        } else if (this.pitch - mouseDY < -90.0f) {
            this.pitch = -90.0f;
        } else if (this.pitch - mouseDY > 90.0f) {
            this.pitch = 90.0f;
        }
    }

    @Override
    public void processMouse(float mouseSpeed) {
        float MAX_LOOK_UP = 90.0f;
        float MAX_LOOK_DOWN = -90.0f;
        float mouseDX = (float)Mouse.getDX() * mouseSpeed * 0.16f;
        float mouseDY = (float)Mouse.getDY() * mouseSpeed * 0.16f;
        this.yaw = this.yaw + mouseDX >= 360.0f ? this.yaw + mouseDX - 360.0f : (this.yaw + mouseDX < 0.0f ? 360.0f - this.yaw + mouseDX : (this.yaw += mouseDX));
        if (this.pitch - mouseDY >= -90.0f && this.pitch - mouseDY <= 90.0f) {
            this.pitch += -mouseDY;
        } else if (this.pitch - mouseDY < -90.0f) {
            this.pitch = -90.0f;
        } else if (this.pitch - mouseDY > 90.0f) {
            this.pitch = 90.0f;
        }
    }

    @Override
    public void processMouse(float mouseSpeed, float maxLookUp, float maxLookDown) {
        float mouseDX = (float)Mouse.getDX() * mouseSpeed * 0.16f;
        float mouseDY = (float)Mouse.getDY() * mouseSpeed * 0.16f;
        this.yaw = this.yaw + mouseDX >= 360.0f ? this.yaw + mouseDX - 360.0f : (this.yaw + mouseDX < 0.0f ? 360.0f - this.yaw + mouseDX : (this.yaw += mouseDX));
        if (this.pitch - mouseDY >= maxLookDown && this.pitch - mouseDY <= maxLookUp) {
            this.pitch += -mouseDY;
        } else if (this.pitch - mouseDY < maxLookDown) {
            this.pitch = maxLookDown;
        } else if (this.pitch - mouseDY > maxLookUp) {
            this.pitch = maxLookUp;
        }
    }

    @Override
    public void processKeyboard(float delta) {
        if (delta <= 0.0f) {
            throw new IllegalArgumentException("delta " + delta + " is 0 or is smaller than 0");
        }
        boolean keyUp = Keyboard.isKeyDown(200) || Keyboard.isKeyDown(17);
        boolean keyDown = Keyboard.isKeyDown(208) || Keyboard.isKeyDown(31);
        boolean keyLeft = Keyboard.isKeyDown(203) || Keyboard.isKeyDown(30);
        boolean keyRight = Keyboard.isKeyDown(205) || Keyboard.isKeyDown(32);
        boolean flyUp = Keyboard.isKeyDown(57);
        boolean flyDown = Keyboard.isKeyDown(42);
        if (keyUp && keyRight && !keyLeft && !keyDown) {
            this.moveFromLook(delta * 0.003f, 0.0f, -delta * 0.003f);
        }
        if (keyUp && keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(-delta * 0.003f, 0.0f, -delta * 0.003f);
        }
        if (keyUp && !keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(0.0f, 0.0f, -delta * 0.003f);
        }
        if (keyDown && keyLeft && !keyRight && !keyUp) {
            this.moveFromLook(-delta * 0.003f, 0.0f, delta * 0.003f);
        }
        if (keyDown && keyRight && !keyLeft && !keyUp) {
            this.moveFromLook(delta * 0.003f, 0.0f, delta * 0.003f);
        }
        if (keyDown && !keyUp && !keyLeft && !keyRight) {
            this.moveFromLook(0.0f, 0.0f, delta * 0.003f);
        }
        if (keyLeft && !keyRight && !keyUp && !keyDown) {
            this.moveFromLook(-delta * 0.003f, 0.0f, 0.0f);
        }
        if (keyRight && !keyLeft && !keyUp && !keyDown) {
            this.moveFromLook(delta * 0.003f, 0.0f, 0.0f);
        }
        if (flyUp && !flyDown) {
            this.y += delta * 0.003f;
        }
        if (flyDown && !flyUp) {
            this.y -= delta * 0.003f;
        }
    }

    @Override
    public void processKeyboard(float delta, float speed) {
        if (delta <= 0.0f) {
            throw new IllegalArgumentException("delta " + delta + " is 0 or is smaller than 0");
        }
        boolean keyUp = Keyboard.isKeyDown(200) || Keyboard.isKeyDown(17);
        boolean keyDown = Keyboard.isKeyDown(208) || Keyboard.isKeyDown(31);
        boolean keyLeft = Keyboard.isKeyDown(203) || Keyboard.isKeyDown(30);
        boolean keyRight = Keyboard.isKeyDown(205) || Keyboard.isKeyDown(32);
        boolean flyUp = Keyboard.isKeyDown(57);
        boolean flyDown = Keyboard.isKeyDown(42);
        if (keyUp && keyRight && !keyLeft && !keyDown) {
            this.moveFromLook(speed * delta * 0.003f, 0.0f, -speed * delta * 0.003f);
        }
        if (keyUp && keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(-speed * delta * 0.003f, 0.0f, -speed * delta * 0.003f);
        }
        if (keyUp && !keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(0.0f, 0.0f, -speed * delta * 0.003f);
        }
        if (keyDown && keyLeft && !keyRight && !keyUp) {
            this.moveFromLook(-speed * delta * 0.003f, 0.0f, speed * delta * 0.003f);
        }
        if (keyDown && keyRight && !keyLeft && !keyUp) {
            this.moveFromLook(speed * delta * 0.003f, 0.0f, speed * delta * 0.003f);
        }
        if (keyDown && !keyUp && !keyLeft && !keyRight) {
            this.moveFromLook(0.0f, 0.0f, speed * delta * 0.003f);
        }
        if (keyLeft && !keyRight && !keyUp && !keyDown) {
            this.moveFromLook(-speed * delta * 0.003f, 0.0f, 0.0f);
        }
        if (keyRight && !keyLeft && !keyUp && !keyDown) {
            this.moveFromLook(speed * delta * 0.003f, 0.0f, 0.0f);
        }
        if (flyUp && !flyDown) {
            this.y += speed * delta * 0.003f;
        }
        if (flyDown && !flyUp) {
            this.y -= speed * delta * 0.003f;
        }
    }

    @Override
    public void processKeyboard(float delta, float speedX, float speedY, float speedZ) {
        if (delta <= 0.0f) {
            throw new IllegalArgumentException("delta " + delta + " is 0 or is smaller than 0");
        }
        boolean keyUp = Keyboard.isKeyDown(200) || Keyboard.isKeyDown(17);
        boolean keyDown = Keyboard.isKeyDown(208) || Keyboard.isKeyDown(31);
        boolean keyLeft = Keyboard.isKeyDown(203) || Keyboard.isKeyDown(30);
        boolean keyRight = Keyboard.isKeyDown(205) || Keyboard.isKeyDown(32);
        boolean flyUp = Keyboard.isKeyDown(57);
        boolean flyDown = Keyboard.isKeyDown(42);
        if (keyUp && keyRight && !keyLeft && !keyDown) {
            this.moveFromLook(speedX * delta * 0.003f, 0.0f, -speedZ * delta * 0.003f);
        }
        if (keyUp && keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(-speedX * delta * 0.003f, 0.0f, -speedZ * delta * 0.003f);
        }
        if (keyUp && !keyLeft && !keyRight && !keyDown) {
            this.moveFromLook(0.0f, 0.0f, -speedZ * delta * 0.003f);
        }
        if (keyDown && keyLeft && !keyRight && !keyUp) {
            this.moveFromLook(-speedX * delta * 0.003f, 0.0f, speedZ * delta * 0.003f);
        }
        if (keyDown && keyRight && !keyLeft && !keyUp) {
            this.moveFromLook(speedX * delta * 0.003f, 0.0f, speedZ * delta * 0.003f);
        }
        if (keyDown && !keyUp && !keyLeft && !keyRight) {
            this.moveFromLook(0.0f, 0.0f, speedZ * delta * 0.003f);
        }
        if (keyLeft && !keyRight && !keyUp && !keyDown) {
            this.moveFromLook(-speedX * delta * 0.003f, 0.0f, 0.0f);
        }
        if (keyRight && !keyLeft && !keyUp && !keyDown) {
            this.moveFromLook(speedX * delta * 0.003f, 0.0f, 0.0f);
        }
        if (flyUp && !flyDown) {
            this.y += speedY * delta * 0.003f;
        }
        if (flyDown && !flyUp) {
            this.y -= speedY * delta * 0.003f;
        }
    }

    @Override
    public void moveFromLook(float dx, float dy, float dz) {
        this.z = (float)((double)this.z + ((double)(dx * (float)Math.cos(Math.toRadians(this.yaw - 90.0f))) + (double)dz * Math.cos(Math.toRadians(this.yaw))));
        this.x = (float)((double)this.x - ((double)(dx * (float)Math.sin(Math.toRadians(this.yaw - 90.0f))) + (double)dz * Math.sin(Math.toRadians(this.yaw))));
        this.y = (float)((double)this.y + ((double)(dy * (float)Math.sin(Math.toRadians(this.pitch - 90.0f))) + (double)dz * Math.sin(Math.toRadians(this.pitch))));
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void applyOrthographicMatrix() {
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(-this.aspectRatio, this.aspectRatio, -1.0, 1.0, 0.0, this.zFar);
        GL11.glPopAttrib();
    }

    @Override
    public void applyOptimalStates() {
        if (GLContext.getCapabilities().GL_ARB_depth_clamp) {
            GL11.glEnable(34383);
        }
    }

    @Override
    public void applyPerspectiveMatrix() {
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective(this.fov, this.aspectRatio, this.zNear, this.zFar);
        GL11.glPopAttrib();
    }

    @Override
    public void applyTranslations() {
        GL11.glPushAttrib(4096);
        GL11.glMatrixMode(5888);
        GL11.glRotatef(this.pitch, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.yaw, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.roll, 0.0f, 0.0f, 1.0f);
        GL11.glTranslatef(-this.x, -this.y, -this.z);
        GL11.glPopAttrib();
    }

    @Override
    public void setRotation(float pitch, float yaw, float roll) {
        this.pitch = pitch;
        this.yaw = yaw;
        this.roll = roll;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    @Override
    public float pitch() {
        return this.pitch;
    }

    @Override
    public float yaw() {
        return this.yaw;
    }

    @Override
    public float roll() {
        return this.roll;
    }

    @Override
    public float fieldOfView() {
        return this.fov;
    }

    @Override
    public void setFieldOfView(float fov) {
        this.fov = fov;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        if (aspectRatio <= 0.0f) {
            throw new IllegalArgumentException("aspectRatio " + aspectRatio + " is 0 or less");
        }
        this.aspectRatio = aspectRatio;
    }

    @Override
    public float aspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public float nearClippingPane() {
        return this.zNear;
    }

    @Override
    public float farClippingPane() {
        return this.zFar;
    }

    public String toString() {
        return "EulerCamera [x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", pitch=" + this.pitch + ", yaw=" + this.yaw + ", " + "roll=" + this.roll + ", fov=" + this.fov + ", aspectRatio=" + this.aspectRatio + ", zNear=" + this.zNear + ", " + "zFar=" + this.zFar + "]";
    }

    /* synthetic */ EulerCamera(Builder builder, EulerCamera eulerCamera) {
        this(builder);
    }

    public static class Builder {
        private float aspectRatio = 1.0f;
        private float x = 0.0f;
        private float y = 0.0f;
        private float z = 0.0f;
        private float pitch = 0.0f;
        private float yaw = 0.0f;
        private float roll = 0.0f;
        private float zNear = 0.3f;
        private float zFar = 100.0f;
        private float fov = 90.0f;

        public Builder setAspectRatio(float aspectRatio) {
            if (aspectRatio <= 0.0f) {
                throw new IllegalArgumentException("aspectRatio " + aspectRatio + " was 0 or was smaller than 0");
            }
            this.aspectRatio = aspectRatio;
            return this;
        }

        public Builder setNearClippingPane(float nearClippingPane) {
            if (nearClippingPane <= 0.0f) {
                throw new IllegalArgumentException("nearClippingPane " + nearClippingPane + " is 0 or less");
            }
            this.zNear = nearClippingPane;
            return this;
        }

        public Builder setFarClippingPane(float farClippingPane) {
            if (farClippingPane <= 0.0f) {
                throw new IllegalArgumentException("farClippingPane " + farClippingPane + " is 0 or less");
            }
            this.zFar = farClippingPane;
            return this;
        }

        public Builder setFieldOfView(float fov) {
            this.fov = fov;
            return this;
        }

        public Builder setPosition(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder setRotation(float pitch, float yaw, float roll) {
            this.pitch = pitch;
            this.yaw = yaw;
            this.roll = roll;
            return this;
        }

        public EulerCamera build() {
            if (this.zFar <= this.zNear) {
                throw new IllegalArgumentException("farClippingPane " + this.zFar + " is the same or less than " + "nearClippingPane " + this.zNear);
            }
            return new EulerCamera(this, null);
        }
    }
}

